/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0007\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"isGithubActionsFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGithubActionFile", "isGithubWorkflowFile", "isGithubActionYamlFile", "isGithubWorkflowYamlFile", "intellij.vcs.github"})
public final class GithubYamlFileDetectionKt {
    public static final boolean isGithubActionsFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getOriginalFile()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return false;
        }
        PsiFile virtualFile = psiFile2;
        return GithubYamlFileDetectionKt.isGithubActionsFile((VirtualFile)virtualFile);
    }

    public static final boolean isGithubActionsFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return GithubYamlFileDetectionKt.isGithubActionYamlFile(virtualFile) || GithubYamlFileDetectionKt.isGithubWorkflowYamlFile(virtualFile);
    }

    public static final boolean isGithubActionFile(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        return GithubYamlFileDetectionKt.isGithubActionYamlFile(virtualFile);
    }

    public static final boolean isGithubWorkflowFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getOriginalFile()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return false;
        }
        PsiFile virtualFile = psiFile2;
        return GithubYamlFileDetectionKt.isGithubWorkflowYamlFile((VirtualFile)virtualFile);
    }

    public static final boolean isGithubWorkflowFile(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        return GithubYamlFileDetectionKt.isGithubWorkflowYamlFile(virtualFile);
    }

    private static final boolean isGithubActionYamlFile(VirtualFile virtualFile) {
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        return VirtualFileUtil.isFile((VirtualFile)virtualFile) && (FileUtilRt.extensionEquals((String)fileName, (String)"yml") || FileUtilRt.extensionEquals((String)fileName, (String)"yaml")) && Intrinsics.areEqual((Object)virtualFile.getNameWithoutExtension(), (Object)"action");
    }

    private static final boolean isGithubWorkflowYamlFile(VirtualFile virtualFile) {
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        String string2 = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String filePath = string2;
        int workflowDirIndex = StringsKt.indexOf$default((CharSequence)filePath, (String)"/workflows", (int)0, (boolean)false, (int)6, null);
        int githubDirIndex = StringsKt.indexOf$default((CharSequence)filePath, (String)".github/", (int)0, (boolean)false, (int)6, null);
        return VirtualFileUtil.isFile((VirtualFile)virtualFile) && (FileUtilRt.extensionEquals((String)fileName, (String)"yml") || FileUtilRt.extensionEquals((String)fileName, (String)"yaml")) && workflowDirIndex != -1 && githubDirIndex != -1 && workflowDirIndex > githubDirIndex;
    }
}

