/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FoldingUtil {
    private FoldingUtil() {
    }

    @Nullable
    public static FoldRegion findFoldRegion(@NotNull Editor editor2, int startOffset, int endOffset) {
        FoldRegion region;
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(0);
        }
        return (region = editor2.getFoldingModel().getFoldRegion(startOffset, endOffset)) != null && region.isValid() ? region : null;
    }

    @Nullable
    public static FoldRegion findFoldRegionStartingAtLine(@NotNull Editor editor2, int line) {
        FoldRegion[] regions;
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(1);
        }
        if (line < 0 || line >= editor2.getDocument().getLineCount()) {
            return null;
        }
        FoldRegion result2 = null;
        for (FoldRegion region : regions = editor2.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid() || region.getDocument().getLineNumber(region.getStartOffset()) != line) continue;
            if (result2 != null) {
                return null;
            }
            result2 = region;
        }
        return result2;
    }

    @NotNull
    public static @NotNull FoldRegion @NotNull [] getFoldRegionsAtOffset(@NotNull Editor editor2, int offset) {
        FoldRegion[] allRegions;
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(2);
        }
        ArrayList<FoldRegion> list2 = new ArrayList<FoldRegion>();
        for (FoldRegion region : allRegions = editor2.getFoldingModel().getAllFoldRegions()) {
            if (!region.getTextRange().containsInclusive(offset)) continue;
            list2.add(region);
        }
        FoldRegion[] regions = list2.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(regions, Collections.reverseOrder(RangeMarker.BY_START_OFFSET));
        if (regions == null) {
            FoldingUtil.$$$reportNull$$$0(3);
        }
        return regions;
    }

    @ApiStatus.Internal
    public static boolean caretInsideRange(@NotNull Editor editor2, @NotNull TextRange range) {
        int offset;
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(4);
        }
        if (range == null) {
            FoldingUtil.$$$reportNull$$$0(5);
        }
        return range.contains(offset = editor2.getCaretModel().getOffset()) && range.getStartOffset() != offset;
    }

    public static boolean isHighlighterFolded(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter) {
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(6);
        }
        if (highlighter == null) {
            FoldingUtil.$$$reportNull$$$0(7);
        }
        int startOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaStartOffset() : highlighter.getStartOffset();
        int endOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaEndOffset() : highlighter.getEndOffset();
        return FoldingUtil.isTextRangeFolded(editor2, new TextRange(startOffset, endOffset));
    }

    public static boolean isTextRangeFolded(@NotNull Editor editor2, @NotNull TextRange range) {
        FoldRegion foldRegion;
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(8);
        }
        if (range == null) {
            FoldingUtil.$$$reportNull$$$0(9);
        }
        return (foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(range.getStartOffset())) != null && range.getEndOffset() <= foldRegion.getEndOffset();
    }

    @NotNull
    public static Iterator<FoldRegion> createFoldTreeIterator(@NotNull Editor editor2) {
        if (editor2 == null) {
            FoldingUtil.$$$reportNull$$$0(10);
        }
        final FoldRegion[] allRegions = editor2.getFoldingModel().getAllFoldRegions();
        return new Iterator<FoldRegion>(){
            private int sectionStart;
            private int current;
            private int sectionEnd;
            {
                this.advanceSection();
            }

            private void advanceSection() {
                this.sectionStart = this.sectionEnd;
                this.sectionEnd = this.sectionStart + 1;
                while (this.sectionEnd < allRegions.length && allRegions[this.sectionEnd].getStartOffset() == allRegions[this.sectionStart].getStartOffset()) {
                    ++this.sectionEnd;
                }
                this.current = this.sectionEnd;
            }

            @Override
            public boolean hasNext() {
                return this.current > this.sectionStart || this.sectionEnd < allRegions.length;
            }

            @Override
            public FoldRegion next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.current <= this.sectionStart) {
                    this.advanceSection();
                }
                return allRegions[--this.current];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUtil";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldRegionsAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegionStartingAtLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegionsAtOffset";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "caretInsideRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterFolded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTextRangeFolded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFoldTreeIterator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

