/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Tag(value="descriptor")
final class WslDistributionDescriptor {
    private static final int PROBE_TIMEOUT = SystemProperties.getIntProperty((String)"ide.wsl.probe.timeout", (int)60000);
    private static final Key<Boolean> CALCULATING_MOUNT_ROOT_COMMAND = new Key("CalculatingMountRootCommand");
    @Tag(value="id")
    @NlsSafe
    private String myId;
    @Tag(value="microsoft-id")
    @NlsSafe
    private String myMsId;
    @Tag(value="executable-path")
    @NlsSafe
    @Nullable
    private String myExecutablePath;
    @Tag(value="presentable-name")
    @NlsSafe
    private String myPresentableName;
    private final ClearableLazyValue<String> myMntRootProvider;

    WslDistributionDescriptor() {
        this.myMntRootProvider = WslDistributionDescriptor.createAtomicClearableLazyValue(() -> WslDistributionDescriptor.executeOrRunTask(pi -> this.computeMntRoot((ProgressIndicator)pi)));
    }

    WslDistributionDescriptor(@NotNull String msId) {
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(0);
        }
        this(msId, msId, null, msId);
    }

    WslDistributionDescriptor(@NotNull String msId, @Nullable String executablePath, @NotNull String presentableName) {
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(2);
        }
        this(msId, msId, executablePath, presentableName);
    }

    WslDistributionDescriptor(@NotNull String id2, @NotNull String msId, @Nullable String executablePath, @NotNull String presentableName) {
        if (id2 == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(3);
        }
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(4);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(5);
        }
        this.myMntRootProvider = WslDistributionDescriptor.createAtomicClearableLazyValue(() -> WslDistributionDescriptor.executeOrRunTask(pi -> this.computeMntRoot((ProgressIndicator)pi)));
        this.myId = id2;
        this.myMsId = msId;
        this.myExecutablePath = executablePath;
        this.myPresentableName = presentableName;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = Objects.requireNonNull(this.myId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = Objects.requireNonNull(this.myMsId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = Objects.requireNonNull(this.myPresentableName);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    boolean isValid() {
        return StringUtil.isNotEmpty((String)this.myId) && StringUtil.isNotEmpty((String)this.myMsId) && StringUtil.isNotEmpty((String)this.myExecutablePath) && StringUtil.isNotEmpty((String)this.myPresentableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslDistributionDescriptor that = (WslDistributionDescriptor)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "WslDistributionDescriptor{id='" + this.myId + "', msId='" + this.myMsId + "'}";
    }

    @NotNull
    @NlsSafe
    String getMntRoot() {
        String string = (String)this.myMntRootProvider.getValue();
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private String computeMntRoot(@Nullable ProgressIndicator pi) {
        long startNano = System.nanoTime();
        String windowsWorkingDirectory = Path.of(".", new String[0]).toAbsolutePath().normalize().toString();
        if (!OSAgnosticPathUtil.isAbsoluteDosPath((String)windowsWorkingDirectory)) {
            WSLUtil.LOG.warn("Failed to get WSL mount root for " + this.getMsId() + ": DOS working directory is expected, but got " + windowsWorkingDirectory);
            return "/mnt/";
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setLaunchWithWslExe(true).setExecuteCommandInShell(false);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"pwd"});
        commandLine.putUserData(CALCULATING_MOUNT_ROOT_COMMAND, (Object)true);
        commandLine.setWorkDirectory(windowsWorkingDirectory);
        String linuxWorkingDirectory = this.readWslOutputLine(options2, commandLine, pi);
        if (linuxWorkingDirectory == null) {
            WSLUtil.LOG.warn("Failed to get WSL mount root for " + this.getMsId() + ": empty output");
            return "/mnt/";
        }
        String linuxWorkingDirectorySuffix = WSLDistribution.convertWindowsPath(windowsWorkingDirectory);
        if (StringUtil.endsWithIgnoreCase((String)linuxWorkingDirectory, (String)linuxWorkingDirectorySuffix)) {
            String mountRoot = StringUtil.trimEnd((String)linuxWorkingDirectory, (String)linuxWorkingDirectorySuffix, (boolean)true);
            WSLUtil.LOG.info("WSL mount root for " + this.getMsId() + " is " + mountRoot + " (done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
            String string = mountRoot;
            if (string == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(10);
            }
            return string;
        }
        WSLUtil.LOG.warn("Failed to get WSL mount root for " + this.getMsId() + ": Linux working directory does not ends with Windows converted suffix. " + String.join((CharSequence)"; ", List.of("Windows pwd=" + windowsWorkingDirectory, "Linux pwd=" + linuxWorkingDirectory, "expected linux suffix=" + linuxWorkingDirectorySuffix)));
        return "/mnt/";
    }

    @Nullable
    private String readWslOutputLine(@NotNull WSLCommandLineOptions options2, @NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator pi) {
        List<String> pwdOutputLines;
        if (options2 == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(12);
        }
        if ((pwdOutputLines = this.readWslOutput(options2, commandLine, pi)) == null) {
            return null;
        }
        if (pwdOutputLines.size() != 1) {
            WSLUtil.LOG.warn("One line response expected: [id=" + this.getId() + "; stdout=" + String.valueOf(pwdOutputLines) + "]");
            return null;
        }
        return pwdOutputLines.get(0).trim();
    }

    private @Unmodifiable @Nullable List<String> readWslOutput(@NotNull WSLCommandLineOptions options2, @NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator pi) {
        ProcessOutput output;
        if (options2 == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(13);
        }
        if (commandLine == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(14);
        }
        WSLDistribution distribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.getId());
        try {
            distribution.doPatchCommandLine(commandLine, null, options2);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            output = pi == null ? processHandler.runProcess(PROBE_TIMEOUT) : processHandler.runProcessWithProgressIndicator(pi, PROBE_TIMEOUT);
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn("Start failed on " + this.getId(), (Throwable)e);
            return null;
        }
        if (output.getExitCode() != 0) {
            WSLUtil.LOG.info("Execution failed on " + this.getId() + " [exitCode=" + output.getExitCode() + "; stderr=" + output.getStderr() + "; stdout=" + output.getStdout() + "]");
            return null;
        }
        return output.getStdoutLines();
    }

    static boolean isCalculatingMountRootCommand(@NotNull GeneralCommandLine commandLine) {
        Boolean data2;
        if (commandLine == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(15);
        }
        return (data2 = (Boolean)commandLine.getUserData(CALCULATING_MOUNT_ROOT_COMMAND)) != null && data2 != false;
    }

    private static <T> T executeOrRunTask(final @NotNull Function<? super @Nullable ProgressIndicator, ? extends T> commandRunner) {
        if (commandRunner == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(16);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return commandRunner.apply(null);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(null, IdeBundle.message((String)"wsl.executing.process", (Object[])new Object[0]), true){

            protected T compute(@NotNull ProgressIndicator indicator2) throws RuntimeException {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return commandRunner.apply(indicator2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/wsl/WslDistributionDescriptor$1", "compute"));
            }
        });
    }

    @NotNull
    public static <T> ClearableLazyValue<T> createAtomicClearableLazyValue(final @NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(17);
        }
        return new ClearableLazyValue<T>(){
            private long myExternalChangesCount = 2.getCurrentExternalChangesCount();

            @NotNull
            protected T compute() {
                Object t = computable.get();
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                return t;
            }

            @NotNull
            public synchronized T getValue() {
                long curExternalChangesCount = 2.getCurrentExternalChangesCount();
                if (curExternalChangesCount != this.myExternalChangesCount) {
                    this.myExternalChangesCount = curExternalChangesCount;
                    this.drop();
                }
                Object object = super.getValue();
                if (object == null) {
                    2.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static long getCurrentExternalChangesCount() {
                return SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/wsl/WslDistributionDescriptor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValue";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandRunner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMntRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readWslOutputLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readWslOutput";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCalculatingMountRootCommand";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeOrRunTask";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAtomicClearableLazyValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

