/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndentData {
    private final int myIndentSpaces;
    private final int mySpaces;

    public IndentData(int indentSpaces, int spaces) {
        this.myIndentSpaces = indentSpaces;
        this.mySpaces = spaces;
    }

    public IndentData(int indentSpaces) {
        this(indentSpaces, 0);
    }

    public int getTotalSpaces() {
        return Math.max(this.mySpaces + this.myIndentSpaces, 0);
    }

    public int getIndentSpaces() {
        return Math.max(this.myIndentSpaces, 0);
    }

    public int getSpaces() {
        return Math.max(this.mySpaces, 0);
    }

    @ApiStatus.Internal
    public IndentData add(IndentData childOffset) {
        return new IndentData(this.myIndentSpaces + childOffset.getIndentSpaces(), this.mySpaces + childOffset.getSpaces());
    }

    @ApiStatus.Internal
    public IndentData add(WhiteSpace whiteSpace) {
        return new IndentData(this.myIndentSpaces + whiteSpace.getIndentOffset(), this.mySpaces + whiteSpace.getSpaces());
    }

    public boolean isEmpty() {
        return this.myIndentSpaces == 0 && this.mySpaces == 0;
    }

    public IndentInfo createIndentInfo() {
        return new IndentInfo(0, this.getIndentSpaces(), this.getSpaces());
    }

    public String toString() {
        return "spaces=" + this.mySpaces + ", indent spaces=" + this.myIndentSpaces;
    }

    public static IndentData createFrom(@NotNull CharSequence chars, int startOffset, int endOffset, int tabSize2) {
        if (chars == null) {
            IndentData.$$$reportNull$$$0(0);
        }
        assert (tabSize2 > 0) : "Invalid tab size: " + tabSize2;
        int indent = 0;
        int alignment = 0;
        boolean hasTabs = false;
        boolean isInAlignmentArea = false;
        block4: for (int i2 = startOffset; i2 < Math.min(chars.length(), endOffset); ++i2) {
            char c = chars.charAt(i2);
            switch (c) {
                case ' ': {
                    if (hasTabs) {
                        isInAlignmentArea = true;
                        ++alignment;
                        continue block4;
                    }
                    ++indent;
                    continue block4;
                }
                case '\t': {
                    if (isInAlignmentArea) {
                        alignment = (alignment / tabSize2 + 1) * tabSize2;
                        continue block4;
                    }
                    hasTabs = true;
                    indent += tabSize2;
                    continue block4;
                }
                default: {
                    throw new InvalidDataException("Unexpected indent character: '" + c + "'");
                }
            }
        }
        return new IndentData(indent, alignment);
    }

    @Nullable
    public static IndentData min(@Nullable IndentData first, @Nullable IndentData second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.getTotalSpaces() < second.getTotalSpaces() ? first : second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/formatting/IndentData", "createFrom"));
    }
}

