/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.WhiteSpace;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class KeptLineFeedsCollector {
    private static final ThreadLocal<KeptLineFeedsCollector> THREAD_LOCAL = new ThreadLocal();
    private final PsiFile myPsiFile;
    private final List<SmartPsiFileRange> myBreaks;

    private KeptLineFeedsCollector(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            KeptLineFeedsCollector.$$$reportNull$$$0(0);
        }
        this.myBreaks = new ArrayList<SmartPsiFileRange>();
        this.myPsiFile = psiFile;
    }

    public static void setup(@NotNull PsiFile psiFile) {
        LanguageCodeStyleProvider provider;
        if (psiFile == null) {
            KeptLineFeedsCollector.$$$reportNull$$$0(1);
        }
        if ((provider = LanguageCodeStyleProvider.findUsingBaseLanguage((Language)psiFile.getLanguage())) != null && provider.usesCommonKeepLineBreaks() && CodeStyle.getLanguageSettings((PsiFile)psiFile).KEEP_LINE_BREAKS) {
            THREAD_LOCAL.set(new KeptLineFeedsCollector(psiFile));
        }
    }

    public static List<Segment> getLineFeedsAndCleanup() {
        KeptLineFeedsCollector collector = THREAD_LOCAL.get();
        if (collector == null) {
            return Collections.emptyList();
        }
        THREAD_LOCAL.remove();
        List segments = ContainerUtil.mapNotNull(collector.myBreaks, range -> range.getRange());
        for (SmartPsiFileRange psiFileRange : collector.myBreaks) {
            SmartPointerManager.getInstance((Project)collector.myPsiFile.getProject()).removePointer((SmartPsiElementPointer)psiFileRange);
        }
        return segments;
    }

    public static void registerLineFeed(WhiteSpace whiteSpace) {
        KeptLineFeedsCollector collector = THREAD_LOCAL.get();
        if (collector == null) {
            return;
        }
        SmartPsiFileRange pointer = SmartPointerManager.getInstance((Project)collector.myPsiFile.getProject()).createSmartPsiFileRangePointer(collector.myPsiFile, whiteSpace.getTextRange());
        collector.myBreaks.add(pointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiFile";
        objectArray2[1] = "com/intellij/formatting/KeptLineFeedsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

