/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChangeLAFAnimator;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.actions.ShowPluginsWithSearchOptionAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.ThemeListProvider;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction
implements ActionRemoteBehaviorSpecification.Frontend {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group2, @NotNull DataContext dataContext2) {
        if (group2 == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(0);
        }
        if (dataContext2 == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(1);
        }
        final UIThemeLookAndFeelInfo initialLaf = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        for (Groups.GroupInfo groupInfo : ThemeListProvider.Companion.getInstance().getShownThemes().getInfos()) {
            if (group2.getChildrenCount() > 0) {
                group2.addSeparator();
            }
            Iterator iterator2 = groupInfo.getItems().iterator();
            while (iterator2.hasNext()) {
                UIThemeLookAndFeelInfo lf;
                group2.add((AnAction)new LafChangeAction(lf, initialLaf == (lf = (UIThemeLookAndFeelInfo)iterator2.next())));
            }
        }
        group2.addSeparator();
        group2.add((AnAction)new ShowPluginsWithSearchOptionAction(this, IdeBundle.message((String)"laf.action.install.theme", (Object[])new Object[0]), "/tag:Theme"){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickChangeLookAndFeel.switchLafAndUpdateUI(LafManager.getInstance(), initialLaf, false);
                super.actionPerformed(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeLookAndFeel$1", "actionPerformed"));
            }
        });
    }

    @NotNull
    protected ListPopup createPopup(AnActionEvent e, DefaultActionGroup group2, JBPopupFactory.ActionSelectionAid aid) {
        if (WelcomeFrame.getInstance() == null && ContainerUtil.exists((Object[])group2.getChildren(e), action2 -> {
            if (!(action2 instanceof LafChangeAction)) return false;
            LafChangeAction lafAction = (LafChangeAction)((Object)action2);
            if (!lafAction.myLookAndFeelInfo.isRestartRequired()) return false;
            return true;
        })) {
            return new PopupFactoryImpl.ActionGroupPopup(this, null, this.getPopupTitle(e), (ActionGroup)group2, e.getDataContext(), this.myActionPlace == null ? "popup" : this.myActionPlace, new PresentationFactory(), ActionPopupOptions.forAid(aid, true, -1, this.preselectAction()), null){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @Override
                protected ListCellRenderer<?> getListElementRenderer() {
                    final JLabel icon1 = new JLabel();
                    final JLabel icon2 = new JLabel();
                    final @NotNull @NotNull List infos = ThemeListProvider.Companion.getInstance().getShownThemes().getInfos();
                    return new PopupListElementRenderer(this, this){

                        @Override
                        protected JComponent layoutComponent(JComponent middleItemComponent) {
                            NonOpaquePanel subPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            subPanel.add((Component)icon1, (Object)"West");
                            subPanel.add((Component)icon2, (Object)"East");
                            icon1.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                            icon2.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
                            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            panel2.add((Component)middleItemComponent);
                            panel2.add((Component)subPanel, (Object)"East");
                            return super.layoutComponent((JComponent)panel2);
                        }

                        protected void customizeComponent(JList list2, Object value, boolean isSelected) {
                            PopupFactoryImpl.ActionItem item;
                            AnAction action2;
                            super.customizeComponent(list2, value, isSelected);
                            icon1.setIcon(null);
                            icon2.setIcon(null);
                            this.myRendererComponent.setToolTipText(null);
                            if (value instanceof PopupFactoryImpl.ActionItem && (action2 = (item = (PopupFactoryImpl.ActionItem)value).getAction()) instanceof LafChangeAction) {
                                LafChangeAction lafAction = (LafChangeAction)action2;
                                QuickChangeLookAndFeel.checkRestartRequired(lafAction, infos, isSelected, icon1, icon2);
                            }
                        }
                    };
                }
            };
        }
        ListPopup listPopup = super.createPopup(e, group2, aid);
        if (listPopup == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    private static boolean checkRestartRequired(@NotNull LafChangeAction lafAction, @NotNull List<Groups.GroupInfo<UIThemeLookAndFeelInfo>> infos, boolean isSelected, @Nullable JLabel icon1, @Nullable JLabel icon2) {
        if (lafAction == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(4);
        }
        UIThemeLookAndFeelInfo currentLaf = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        if (lafAction.myLookAndFeelInfo.isRestartRequired()) {
            Groups.GroupInfo group2;
            if (icon1 != null) {
                icon1.setIcon(AllIcons.General.Beta);
            }
            if (!isSelected && (group2 = (Groups.GroupInfo)ContainerUtil.find(infos, info -> ContainerUtil.find((Iterable)info.getItems(), element -> element.getId().equals(lafAction.myLookAndFeelInfo.getId())) != null)) != null && ContainerUtil.find((Iterable)group2.getItems(), element -> element.getId().equals(currentLaf.getId())) == null) {
                if (icon2 != null) {
                    icon2.setIcon(IconUtilKt.getDisabledIcon((Icon)AllIcons.Actions.Restart, null));
                }
                return true;
            }
        } else if (!isSelected && currentLaf.isRestartRequired()) {
            if (icon2 != null) {
                icon2.setIcon(IconUtilKt.getDisabledIcon((Icon)AllIcons.Actions.Restart, null));
            }
            return true;
        }
        return false;
    }

    protected void showPopup(AnActionEvent e, ListPopup popup2) {
        ((QuickChangeLookAndFeelService)ApplicationManager.getApplication().getService(QuickChangeLookAndFeelService.class)).preparePopup(popup2);
        super.showPopup(e, popup2);
    }

    @NotNull
    protected Condition<? super AnAction> preselectAction() {
        LafManager lafMan = LafManager.getInstance();
        Condition condition = a -> a instanceof LafChangeAction && ((LafChangeAction)a).myLookAndFeelInfo == lafMan.getCurrentUIThemeLookAndFeel();
        if (condition == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(5);
        }
        return condition;
    }

    public static void switchLafAndUpdateUI(@NotNull LafManager lafManager, @NotNull UIManager.LookAndFeelInfo laf, boolean async2) {
        if (lafManager == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(6);
        }
        if (laf == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(7);
        }
        QuickChangeLookAndFeel.switchLafAndUpdateUI(lafManager, (UIThemeLookAndFeelInfo)laf, async2, false, false);
    }

    public static void switchLafAndUpdateUI(@NotNull LafManager lafManager, @NotNull UIThemeLookAndFeelInfo laf, boolean async2) {
        if (lafManager == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(8);
        }
        if (laf == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(9);
        }
        QuickChangeLookAndFeel.switchLafAndUpdateUI(lafManager, laf, async2, false, false);
    }

    @ApiStatus.Internal
    public static void switchLafAndUpdateUI(@NotNull LafManager lafManager, @NotNull UIThemeLookAndFeelInfo laf, boolean async2, boolean force, boolean lockEditorScheme) {
        if (lafManager == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(10);
        }
        if (laf == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(11);
        }
        QuickChangeLookAndFeelService.switchLafAndUpdateUI(lafManager, laf, async2, force, lockEditorScheme);
    }

    protected boolean isEnabled() {
        return UiThemeProviderListManager.Companion.getInstance().getLaFListSize() > 1 && !LafManager.getInstance().getAutodetect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/QuickChangeLookAndFeel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lafAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lafManager";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "laf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/QuickChangeLookAndFeel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "preselectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillActions";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkRestartRequired";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "switchLafAndUpdateUI";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    private static final class LafChangeAction
    extends DumbAwareAction {
        private final UIThemeLookAndFeelInfo myLookAndFeelInfo;

        private LafChangeAction(UIThemeLookAndFeelInfo laf, boolean currentLaf) {
            super(laf.getName(), null, LafChangeAction.getIcon(currentLaf));
            this.myLookAndFeelInfo = laf;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LafChangeAction.$$$reportNull$$$0(0);
            }
            QuickChangeLookAndFeel.switchLafAndUpdateUI(LafManager.getInstance(), this.myLookAndFeelInfo, false);
            LafManager.getInstance().checkRestart();
        }

        @Nullable
        private static Icon getIcon(boolean currentLaf) {
            return Registry.is((String)"ide.instant.theme.switch") ? null : (currentLaf ? AllIcons.Actions.Forward : QuickSwitchSchemeAction.ourNotCurrentAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeLookAndFeel$LafChangeAction", "actionPerformed"));
        }
    }

    @Service(value={Service.Level.APP})
    static final class QuickChangeLookAndFeelService {
        private final Alarm switchAlarm;

        QuickChangeLookAndFeelService(CoroutineScope cs) {
            this.switchAlarm = new Alarm(cs, Alarm.ThreadToUse.SWING_THREAD);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        void preparePopup(ListPopup popup2) {
            final UIThemeLookAndFeelInfo initialLaf = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
            @NotNull @NotNull List infos = ThemeListProvider.Companion.getInstance().getShownThemes().getInfos();
            this.switchAlarm.cancelAllRequests();
            if (Registry.is((String)"ide.instant.theme.switch")) {
                popup2.addListSelectionListener(event -> {
                    LafChangeAction action2;
                    AnAction anAction;
                    Object item = ((JList)event.getSource()).getSelectedValue();
                    if (item instanceof AnActionHolder && (anAction = ((AnActionHolder)item).getAction()) instanceof LafChangeAction && !QuickChangeLookAndFeel.checkRestartRequired(action2 = (LafChangeAction)anAction, infos, false, null, null)) {
                        this.switchAlarm.cancelAllRequests();
                        this.switchAlarm.addRequest(() -> QuickChangeLookAndFeelService.switchLafAndUpdateUI(LafManager.getInstance(), action2.myLookAndFeelInfo), Registry.get((String)"ide.instant.theme.switch.delay").asInteger());
                    }
                });
            }
            popup2.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    switchAlarm.cancelAllRequests();
                    if (Registry.is((String)"ide.instant.theme.switch") && !event.isOk()) {
                        QuickChangeLookAndFeelService.switchLafAndUpdateUI(LafManager.getInstance(), initialLaf);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/QuickChangeLookAndFeel$QuickChangeLookAndFeelService$1", "onClosed"));
                }
            });
        }

        static void switchLafAndUpdateUI(@NotNull LafManager lafManager, @NotNull UIThemeLookAndFeelInfo laf) {
            if (lafManager == null) {
                QuickChangeLookAndFeelService.$$$reportNull$$$0(0);
            }
            if (laf == null) {
                QuickChangeLookAndFeelService.$$$reportNull$$$0(1);
            }
            QuickChangeLookAndFeelService.switchLafAndUpdateUI(lafManager, laf, false, false, false);
        }

        static void switchLafAndUpdateUI(@NotNull LafManager lafManager, @NotNull UIThemeLookAndFeelInfo lf, boolean async2, boolean force, boolean lockEditorScheme) {
            if (lafManager == null) {
                QuickChangeLookAndFeelService.$$$reportNull$$$0(2);
            }
            if (lf == null) {
                QuickChangeLookAndFeelService.$$$reportNull$$$0(3);
            }
            UIThemeLookAndFeelInfo cur = lafManager.getCurrentUIThemeLookAndFeel();
            if (!force && cur == lf) {
                return;
            }
            ChangeLAFAnimator animator = Registry.is((String)"ide.intellij.laf.enable.animation") ? ChangeLAFAnimator.showSnapshot() : null;
            boolean wasDarcula = StartupUiUtil.isUnderDarcula();
            lafManager.setCurrentLookAndFeel(lf, lockEditorScheme);
            Runnable updater = () -> {
                Ref updated = Ref.create((Object)false);
                Disposable disposable = Disposer.newDisposable();
                ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(LafManagerListener.TOPIC, source -> updated.set((Object)true));
                try {
                    if (StartupUiUtil.isUnderDarcula()) {
                        DarculaInstaller.install();
                    } else if (wasDarcula) {
                        DarculaInstaller.uninstall();
                    }
                }
                finally {
                    Disposer.dispose((Disposable)disposable);
                    if (!((Boolean)updated.get()).booleanValue()) {
                        lafManager.updateUI();
                    }
                    if (animator != null) {
                        animator.hideSnapshotWithAnimation();
                    }
                }
            };
            if (async2) {
                SwingUtilities.invokeLater(updater);
            } else {
                updater.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lafManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "laf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lf";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/QuickChangeLookAndFeel$QuickChangeLookAndFeelService";
            objectArray[2] = "switchLafAndUpdateUI";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

