/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.util.IconLoaderKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\bR:\u0010\u0004\u001a.\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0005j\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/ui/NotPatchedIconRegistry;", "", "<init>", "()V", "paths", "Ljava/util/HashSet;", "Lkotlin/Pair;", "", "Ljava/lang/ClassLoader;", "Lkotlin/collections/HashSet;", "getData", "", "Lcom/intellij/ide/ui/NotPatchedIconRegistry$IconModel;", "registerNotPatchedIcon", "", "path", "classLoader", "IconModel", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class NotPatchedIconRegistry {
    @NotNull
    public static final NotPatchedIconRegistry INSTANCE = new NotPatchedIconRegistry();
    @NotNull
    private static final HashSet<Pair<String, ClassLoader>> paths = new HashSet();

    private NotPatchedIconRegistry() {
    }

    @NotNull
    public final List<IconModel> getData() {
        ArrayList<IconModel> result2 = new ArrayList<IconModel>(paths.size());
        Iterator<Pair<String, ClassLoader>> iterator2 = paths.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Pair<String, ClassLoader>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ClassLoader classLoader;
            Pair<String, ClassLoader> pair;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), (String)"next(...)");
            String path = (String)pair.component1();
            ClassLoader second = (ClassLoader)pair.component2();
            ClassLoader classLoader2 = second;
            if (classLoader2 == null) {
                classLoader2 = NotPatchedIconRegistry.class.getClassLoader();
            }
            ClassLoader classLoader3 = classLoader = classLoader2;
            Intrinsics.checkNotNull((Object)classLoader3);
            Icon icon2 = IconLoaderKt.findIconUsingNewImplementation((String)path, (ClassLoader)classLoader3, null);
            result2.add(new IconModel(icon2, path));
        }
        return result2;
    }

    public final void registerNotPatchedIcon(@NotNull String path, @Nullable ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        paths.add((Pair<String, ClassLoader>)new Pair((Object)path, (Object)classLoader));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u00020\u0005H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/ui/NotPatchedIconRegistry$IconModel;", "", "icon", "Ljavax/swing/Icon;", "originalPath", "", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;)V", "toString", "intellij.platform.ide.impl"})
    public static final class IconModel {
        @JvmField
        @Nullable
        public Icon icon;
        @JvmField
        @NotNull
        public String originalPath;

        public IconModel(@Nullable Icon icon2, @NotNull String originalPath) {
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            this.icon = icon2;
            this.originalPath = originalPath;
        }

        @NotNull
        public String toString() {
            return this.originalPath;
        }
    }
}

