/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandId;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.LocalCommandMergerSnapshot;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.PerformedCommand;
import com.intellij.openapi.command.impl.UndoAffectedDocuments;
import com.intellij.openapi.command.impl.UndoCommandFlushReason;
import com.intellij.openapi.command.impl.UndoDumpUnit;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CommandMerger {
    private final boolean isLocalHistoryActivity;
    private final boolean isTransparentSupported;
    @NotNull
    private List<CommandId> commandIds = new ArrayList<CommandId>();
    private @NlsContexts.Command @Nullable String commandName;
    @Nullable
    private Reference<Object> lastGroupId;
    @NotNull
    private UndoRedoList<UndoableAction> undoableActions = new UndoRedoList();
    @NotNull
    private UndoAffectedDocuments affectedDocuments = new UndoAffectedDocuments();
    @NotNull
    private UndoAffectedDocuments additionalAffectedDocuments = new UndoAffectedDocuments();
    @NotNull
    private UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
    @Nullable
    private EditorAndState editorStateBefore;
    @Nullable
    private EditorAndState editorStateAfter;
    private boolean isForcedGlobal;
    private boolean isTransparent;
    private boolean isValid = true;

    public static boolean canMergeGroup(Object groupId, Object lastGroupId) {
        return groupId != null && Comparing.equal((Object)lastGroupId, (Object)groupId);
    }

    CommandMerger(boolean isLocalHistoryActivity, boolean isTransparentSupported) {
        this.isLocalHistoryActivity = isLocalHistoryActivity;
        this.isTransparentSupported = isTransparentSupported;
    }

    boolean isUndoAvailable(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(0);
        }
        if (this.hasNonUndoableActions()) {
            return false;
        }
        if (refs.isEmpty()) {
            return this.isGlobal() && this.hasActions();
        }
        for (DocumentReference doc : refs) {
            if (!this.hasChangesOf(doc)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    UndoCommandFlushReason shouldFlush(@NotNull PerformedCommand performedCommand) {
        if (performedCommand == null) {
            CommandMerger.$$$reportNull$$$0(1);
        }
        if (this.isPartialForeignCommand(performedCommand)) {
            return null;
        }
        if (!this.isCompatible(performedCommand.commandId())) {
            return this.createFlushReason("INCOMPATIBLE_COMMAND", performedCommand);
        }
        if (this.isTransparentSupported && performedCommand.isTransparent() && performedCommand.editorStateAfter() == null && this.editorStateAfter != null) {
            return this.createFlushReason("NEXT_TRANSPARENT_WITHOUT_EDITOR_STATE_AFTER", performedCommand);
        }
        if (this.isTransparentSupported && this.isTransparent() && this.editorStateBefore == null && performedCommand.editorStateBefore() != null) {
            return this.createFlushReason("CURRENT_TRANSPARENT_WITHOUT_EDITOR_STATE_BEFORE", performedCommand);
        }
        if (this.isTransparent() || performedCommand.isTransparent()) {
            boolean changedDocs = this.hasActions() && performedCommand.hasActions() && !this.affectedDocuments.equals(performedCommand.affectedDocuments());
            return changedDocs ? this.createFlushReason("TRANSPARENT_WITH_DIFFERENT_DOCS", performedCommand) : null;
        }
        if ((this.isForcedGlobal || performedCommand.isForcedGlobal()) && !CommandMerger.isMergeGlobalCommandsAllowed()) {
            return this.createFlushReason("GLOBAL", performedCommand);
        }
        boolean canMergeGroup = CommandMerger.canMergeGroup(performedCommand.groupId(), SoftReference.dereference(this.lastGroupId));
        return canMergeGroup ? null : this.createFlushReason("CHANGED_GROUP", performedCommand);
    }

    @Nullable
    UndoableGroup formGroup(@NotNull UndoCommandFlushReason flushReason, int commandTimestamp) {
        if (flushReason == null) {
            CommandMerger.$$$reportNull$$$0(2);
        }
        UndoableGroup group2 = !this.hasActions() ? null : this.createUndoableGroup(flushReason, commandTimestamp);
        this.reset();
        return group2;
    }

    void mergeWithPerformedCommand(@NotNull PerformedCommand performedCommand) {
        if (performedCommand == null) {
            CommandMerger.$$$reportNull$$$0(3);
        }
        this.mergeState(performedCommand);
        if (!performedCommand.isTransparent() && this.hasActions()) {
            Object groupId = performedCommand.groupId();
            if (groupId != SoftReference.dereference(this.lastGroupId)) {
                WeakReference<Object> weakReference = this.lastGroupId = groupId == null ? null : new WeakReference<Object>(groupId);
            }
            if (this.commandName == null) {
                this.commandName = performedCommand.commandName();
            }
        }
    }

    void invalidateActionsFor(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            CommandMerger.$$$reportNull$$$0(4);
        }
        if (this.affectedDocuments.affects(ref2)) {
            this.isValid = false;
        }
    }

    @Nullable
    LocalCommandMergerSnapshot getSnapshot(@NotNull DocumentReference reference) {
        DocumentReference currentReference;
        if (reference == null) {
            CommandMerger.$$$reportNull$$$0(5);
        }
        if (this.isGlobal() || this.additionalAffectedDocuments.size() > 0 || this.affectedDocuments.size() > 1) {
            return null;
        }
        if (this.affectedDocuments.size() == 1 && (currentReference = this.affectedDocuments.firstAffected()) != reference) {
            return null;
        }
        return new LocalCommandMergerSnapshot(this.affectedDocuments.firstAffected(), this.undoableActions.snapshot(), this.lastGroupId, this.isTransparent(), this.commandName, this.editorStateBefore, this.editorStateAfter, this.undoConfirmationPolicy);
    }

    boolean resetLocalHistory(@NotNull LocalCommandMergerSnapshot snapshot2) {
        if (snapshot2 == null) {
            CommandMerger.$$$reportNull$$$0(6);
        }
        UndoAffectedDocuments references = new UndoAffectedDocuments();
        references.addAffected(snapshot2.getDocumentReferences());
        this.reset(new ArrayList<CommandId>(), snapshot2.getActions().toList(), references, new UndoAffectedDocuments(), snapshot2.getLastGroupId(), false, snapshot2.getTransparent(), snapshot2.getCommandName(), true, snapshot2.getStateBefore(), snapshot2.getStateAfter(), snapshot2.getUndoConfirmationPolicy());
        return true;
    }

    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            CommandMerger.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DocumentReference refByFile = DocumentReferenceManager.getInstance().create(document2);
        DocumentReferenceByDocument refByDoc = new DocumentReferenceByDocument(document2);
        this.undoableActions.removeIf(action2 -> {
            Object[] refs = (DocumentReference[])ObjectUtils.notNull((Object)action2.getAffectedDocuments(), (Object)DocumentReference.EMPTY_ARRAY);
            return ContainerUtil.and((Object[])refs, ref2 -> ref2.equals((Object)refByDoc) || ref2.equals((Object)refByFile));
        });
        this.affectedDocuments.removeAffected(refByFile);
        this.affectedDocuments.removeAffected(refByDoc);
        this.additionalAffectedDocuments.removeAffected(refByFile);
        this.additionalAffectedDocuments.removeAffected(refByDoc);
    }

    @Nullable
    String getCommandName() {
        return this.commandName;
    }

    @Nullable
    Object getLastGroupId() {
        return SoftReference.dereference(this.lastGroupId);
    }

    boolean isGlobal() {
        return this.isForcedGlobal || this.affectedDocuments.affectsMultiplePhysical();
    }

    boolean isTransparent() {
        if (this.isTransparentSupported) {
            return this.isTransparent;
        }
        return this.isTransparent && !this.hasActions();
    }

    @NotNull
    UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = this.undoConfirmationPolicy;
        if (undoConfirmationPolicy == null) {
            CommandMerger.$$$reportNull$$$0(8);
        }
        return undoConfirmationPolicy;
    }

    boolean hasActions() {
        return !this.undoableActions.isEmpty();
    }

    @NotNull
    UndoRedoList<UndoableAction> getCurrentActions() {
        UndoRedoList<UndoableAction> undoRedoList = this.undoableActions;
        if (undoRedoList == null) {
            CommandMerger.$$$reportNull$$$0(9);
        }
        return undoRedoList;
    }

    boolean isValid() {
        return this.isValid;
    }

    @NotNull
    Collection<DocumentReference> getAffectedDocuments() {
        Collection<DocumentReference> collection = this.affectedDocuments.asCollection();
        if (collection == null) {
            CommandMerger.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    Collection<DocumentReference> getAdditionalAffectedDocuments() {
        Collection<DocumentReference> collection = this.additionalAffectedDocuments.asCollection();
        if (collection == null) {
            CommandMerger.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    Collection<CommandId> getCommandIds() {
        List<CommandId> list2 = this.commandIds;
        if (list2 == null) {
            CommandMerger.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Nullable
    EditorAndState getStateBefore() {
        return this.editorStateBefore;
    }

    @Nullable
    EditorAndState getStateAfter() {
        return this.editorStateAfter;
    }

    @NotNull
    String dumpState() {
        String string = UndoDumpUnit.fromMerger(this).toString();
        if (string == null) {
            CommandMerger.$$$reportNull$$$0(13);
        }
        return string;
    }

    private void setEditorStateBefore(@Nullable EditorAndState state2) {
        if (this.editorStateBefore == null || !this.hasActions()) {
            this.editorStateBefore = state2;
        }
    }

    private void setEditorStateAfter(@Nullable EditorAndState state2) {
        this.editorStateAfter = state2;
    }

    private void mergeConfirmationPolicy(@NotNull UndoConfirmationPolicy newConfirmationPolicy) {
        if (newConfirmationPolicy == null) {
            CommandMerger.$$$reportNull$$$0(14);
        }
        if (this.undoConfirmationPolicy == UndoConfirmationPolicy.DEFAULT) {
            this.undoConfirmationPolicy = newConfirmationPolicy;
        } else if (this.undoConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && newConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            this.undoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        }
    }

    private boolean hasChangesOf(DocumentReference ref2) {
        for (UndoableAction action2 : this.undoableActions) {
            Object[] refs = action2.getAffectedDocuments();
            if (refs != null && !ArrayUtil.contains((Object)ref2, (Object[])refs)) continue;
            return true;
        }
        return this.hasActions() && this.additionalAffectedDocuments.affects(ref2);
    }

    private void mergeState(@NotNull PerformedCommand performedCommand) {
        if (performedCommand == null) {
            CommandMerger.$$$reportNull$$$0(15);
        }
        if (performedCommand.shouldRecordId()) {
            this.commandIds.add(performedCommand.commandId());
        }
        this.setEditorStateBefore(performedCommand.editorStateBefore());
        this.setEditorStateAfter(performedCommand.editorStateAfter());
        if (this.isTransparent()) {
            if (performedCommand.hasActions()) {
                this.isTransparent = performedCommand.isTransparent();
            }
        } else if (!this.hasActions()) {
            this.isTransparent = performedCommand.isTransparent();
        }
        this.isValid &= performedCommand.isValid();
        this.isForcedGlobal |= performedCommand.isForcedGlobal();
        this.undoableActions.addAll(performedCommand.undoableActions());
        this.affectedDocuments.addAffected(performedCommand.affectedDocuments());
        this.additionalAffectedDocuments.addAffected(performedCommand.additionalAffectedDocuments());
        this.mergeConfirmationPolicy(performedCommand.confirmationPolicy());
    }

    @NotNull
    private UndoCommandFlushReason createFlushReason(@NotNull String reason, @NotNull PerformedCommand performedCommand) {
        if (reason == null) {
            CommandMerger.$$$reportNull$$$0(16);
        }
        if (performedCommand == null) {
            CommandMerger.$$$reportNull$$$0(17);
        }
        UndoCommandFlushReason undoCommandFlushReason = UndoCommandFlushReason.cannotMergeCommands(reason, this.commandName, SoftReference.dereference(this.lastGroupId), this.isTransparent(), this.isForcedGlobal, performedCommand.commandName(), performedCommand.groupId(), performedCommand.isTransparent(), performedCommand.isGlobal());
        if (undoCommandFlushReason == null) {
            CommandMerger.$$$reportNull$$$0(18);
        }
        return undoCommandFlushReason;
    }

    @NotNull
    private UndoableGroup createUndoableGroup(@NotNull UndoCommandFlushReason flushReason, int commandTimestamp) {
        if (flushReason == null) {
            CommandMerger.$$$reportNull$$$0(19);
        }
        if (this.additionalAffectedDocuments.size() > 0) {
            DocumentReference[] refs = this.additionalAffectedDocuments.asCollection().toArray(DocumentReference.EMPTY_ARRAY);
            this.undoableActions.add((UndoableAction)new MyEmptyUndoableAction(refs));
        }
        return new UndoableGroup(this.commandIds, this.commandName, this.undoableActions, this.undoConfirmationPolicy, this.editorStateBefore, this.editorStateAfter, flushReason, commandTimestamp, this.isLocalHistoryActivity, this.isTransparent(), this.isGlobal(), this.isValid);
    }

    private void reset() {
        this.reset(new ArrayList<CommandId>(), new UndoRedoList<UndoableAction>(), new UndoAffectedDocuments(), new UndoAffectedDocuments(), null, false, false, null, true, null, null, UndoConfirmationPolicy.DEFAULT);
    }

    private void reset(List<CommandId> commandIds, UndoRedoList<UndoableAction> currentActions, UndoAffectedDocuments allAffectedDocuments, UndoAffectedDocuments additionalAffectedDocuments, Reference<Object> lastGroupId, boolean forcedGlobal, boolean transparent, @NlsContexts.Command String commandName, boolean isValid, EditorAndState editorStateBefore, EditorAndState editorStateAfter, UndoConfirmationPolicy undoConfirmationPolicy) {
        this.commandIds = commandIds;
        this.undoableActions = currentActions;
        this.affectedDocuments = allAffectedDocuments;
        this.additionalAffectedDocuments = additionalAffectedDocuments;
        this.lastGroupId = lastGroupId;
        this.isForcedGlobal = forcedGlobal;
        this.isTransparent = transparent;
        this.commandName = commandName;
        this.isValid = isValid;
        this.editorStateBefore = editorStateBefore;
        this.editorStateAfter = editorStateAfter;
        this.undoConfirmationPolicy = undoConfirmationPolicy;
    }

    private boolean hasNonUndoableActions() {
        for (UndoableAction each : this.undoableActions) {
            if (!(each instanceof NonUndoableAction)) continue;
            return true;
        }
        return false;
    }

    private boolean isCompatible(@NotNull CommandId commandId) {
        if (commandId == null) {
            CommandMerger.$$$reportNull$$$0(20);
        }
        return true;
    }

    private boolean isPartialForeignCommand(@NotNull PerformedCommand performedCommand) {
        if (performedCommand == null) {
            CommandMerger.$$$reportNull$$$0(21);
        }
        return performedCommand.isForeign() && !this.commandIds.isEmpty() && this.commandIds.getLast().equals(performedCommand.commandId());
    }

    private static boolean isMergeGlobalCommandsAllowed() {
        return ((CoreCommandProcessor)CommandProcessor.getInstance()).isMergeGlobalCommandsAllowed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performedCommand";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushReason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandMerger";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfirmationPolicy";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandMerger";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalAffectedDocuments";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFlushReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldFlush";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithPerformedCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetLocalHistory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeConfirmationPolicy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFlushReason";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createUndoableGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPartialForeignCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 18 -> new IllegalStateException(string);
        };
    }

    private static final class MyEmptyUndoableAction
    extends BasicUndoableAction {
        MyEmptyUndoableAction(DocumentReference @NotNull [] refs) {
            if (refs == null) {
                MyEmptyUndoableAction.$$$reportNull$$$0(0);
            }
            super(refs);
        }

        public void undo() {
        }

        public void redo() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/CommandMerger$MyEmptyUndoableAction", "<init>"));
        }
    }
}

