/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.ad.markup;

import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupListener;
import com.intellij.openapi.editor.impl.ad.AdTheManager;
import com.intellij.openapi.editor.impl.ad.document.AdEntityProvider;
import com.intellij.openapi.editor.impl.ad.markup.AdDocumentMarkupManager;
import com.intellij.openapi.editor.impl.ad.markup.AdMarkupEntity;
import com.intellij.openapi.editor.impl.ad.util.AsyncEntityHandle;
import com.intellij.openapi.editor.impl.ad.util.AsyncEntityService;
import com.intellij.openapi.editor.impl.ad.util.EntityCleanService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.project.ProjectId;
import com.intellij.platform.project.ProjectIdKt;
import fleet.util.UID;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl;", "Lcom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getMarkupEntity", "Lcom/intellij/openapi/editor/impl/ad/markup/AdMarkupEntity;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "(Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMarkupEntityRunBlocking", "createDocMarkupEntity", "", "project", "Lcom/intellij/openapi/project/Project;", "deleteDocMarkupEntity", "getDocMarkupUid", "Lfleet/util/UID;", "provider", "Lcom/intellij/openapi/editor/impl/ad/document/AdEntityProvider;", "getMarkupHandle", "Lcom/intellij/openapi/editor/impl/ad/util/AsyncEntityHandle;", "isEnabled", "", "Companion", "AdDocumentMarkupListener", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nAdDocumentMarkupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdDocumentMarkupManager.kt\ncom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl\n+ 2 PlatformDependent.kt\ncom/jetbrains/rd/util/PlatformDependentKt\n*L\n1#1,151:1\n82#2:152\n*S KotlinDebug\n*F\n+ 1 AdDocumentMarkupManager.kt\ncom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl\n*L\n72#1:152\n*E\n"})
final class AdDocumentMarkupManagerImpl
implements AdDocumentMarkupManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private static final Key<AsyncEntityHandle<AdMarkupEntity>> MARKUP_ENTITY_HANDLE_KEY;

    public AdDocumentMarkupManagerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.lock = new ReentrantLock();
    }

    @Override
    @Nullable
    public Object getMarkupEntity(@NotNull MarkupModelEx markupModel, @NotNull Continuation<? super AdMarkupEntity> $completion) {
        AdMarkupEntity adMarkupEntity;
        AsyncEntityHandle<AdMarkupEntity> asyncEntityHandle = this.getMarkupHandle(markupModel);
        if (asyncEntityHandle != null) {
            Object object = asyncEntityHandle.entity($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            adMarkupEntity = (AdMarkupEntity)object;
        } else {
            adMarkupEntity = null;
        }
        return adMarkupEntity;
    }

    @Override
    @Nullable
    public AdMarkupEntity getMarkupEntityRunBlocking(@NotNull MarkupModelEx markupModel) {
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        AsyncEntityHandle<AdMarkupEntity> asyncEntityHandle = this.getMarkupHandle(markupModel);
        return asyncEntityHandle != null ? asyncEntityHandle.entityRunBlocking() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createDocMarkupEntity(Project project2, MarkupModelEx markupModel) {
        if (this.isEnabled()) {
            AdEntityProvider entityProvider = AdEntityProvider.Companion.getInstance$intellij_platform_ide_impl();
            String debugName = markupModel.toString();
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                boolean value$iv = markupModel.getUserData(MARKUP_ENTITY_HANDLE_KEY) == null;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    boolean bl2 = false;
                    String string = "unexpected existence of document markup entity already exists " + debugName;
                    throw new AssertionError((Object)string);
                }
                UID docMarkupUid = this.getDocMarkupUid(project2, markupModel, entityProvider);
                if (docMarkupUid != null) {
                    AsyncEntityHandle<AdMarkupEntity> handle2 = AsyncEntityService.Companion.getInstance().createHandle(debugName, (Function1)new Function1<Continuation<? super AdMarkupEntity>, Object>(entityProvider, docMarkupUid, markupModel, null){
                        int label;
                        final /* synthetic */ AdEntityProvider $entityProvider;
                        final /* synthetic */ UID $docMarkupUid;
                        final /* synthetic */ MarkupModelEx $markupModel;
                        {
                            this.$entityProvider = $entityProvider;
                            this.$docMarkupUid = $docMarkupUid;
                            this.$markupModel = $markupModel;
                            super(1, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.$entityProvider.createDocMarkupEntity(this.$docMarkupUid, this.$markupModel, (Continuation<? super AdMarkupEntity>)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super AdMarkupEntity> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    EntityCleanService.Companion.getInstance().registerEntity(markupModel, debugName, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(handle2, entityProvider, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ AsyncEntityHandle<AdMarkupEntity> $handle;
                        final /* synthetic */ AdEntityProvider $entityProvider;
                        {
                            this.$handle = $handle;
                            this.$entityProvider = $entityProvider;
                            super(1, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = this.$handle.entity((Continuation<AdMarkupEntity>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    entity = (AdMarkupEntity)v0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)entity);
                                    this.label = 2;
                                    v1 = this.$entityProvider.deleteDocMarkupEntity(entity, (Continuation<? super Unit>)((Continuation)this));
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl24
                                }
                                case 2: {
                                    entity = (AdMarkupEntity)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl24:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    markupModel.putUserData(MARKUP_ENTITY_HANDLE_KEY, handle2);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteDocMarkupEntity(MarkupModelEx markupModel) {
        if (this.isEnabled()) {
            AdEntityProvider provider = AdEntityProvider.Companion.getInstance$intellij_platform_ide_impl();
            String debugName = markupModel.getDocument().toString();
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                AsyncEntityHandle handle2 = (AsyncEntityHandle)markupModel.getUserData(MARKUP_ENTITY_HANDLE_KEY);
                if (handle2 == null) {
                    boolean bl2 = false;
                    String string = "document markup entity not found " + debugName;
                    throw new IllegalStateException(string.toString());
                }
                Deferred deferred2 = BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)AdTheManager.Companion.getAD_DISPATCHER$intellij_platform_ide_impl()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((AsyncEntityHandle<AdMarkupEntity>)handle2, provider, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ AsyncEntityHandle<AdMarkupEntity> $handle;
                    final /* synthetic */ AdEntityProvider $provider;
                    {
                        this.$handle = $handle;
                        this.$provider = $provider;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.$handle.entity((Continuation<AdMarkupEntity>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                entity = (AdMarkupEntity)v0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)entity);
                                this.label = 2;
                                v1 = this.$provider.deleteDocMarkupEntity(entity, (Continuation<? super Unit>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl24
                            }
                            case 2: {
                                entity = (AdMarkupEntity)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl24:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private final UID getDocMarkupUid(Project project2, MarkupModelEx markupModel, AdEntityProvider provider) {
        Document document2 = markupModel.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        if (document3 instanceof DocumentEx) {
            String projectIdAsString;
            if (project2 == null) {
                v1 = "";
            } else {
                ProjectId projectId = ProjectIdKt.projectIdOrNull((Project)project2);
                v1 = projectIdAsString = projectId != null ? projectId.serializeToString() : null;
            }
            if (projectIdAsString != null) {
                String docUidAsString;
                UID uID = provider.getDocEntityUid((DocumentEx)document3);
                String string = docUidAsString = uID != null ? uID.toString() : null;
                if (docUidAsString != null) {
                    String string2 = projectIdAsString + docUidAsString;
                    byte[] byArray = string2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    UUID documentMarkupId = UUID.nameUUIDFromBytes(byArray);
                    String string3 = documentMarkupId.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    return UID.Companion.fromString(string3);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AsyncEntityHandle<AdMarkupEntity> getMarkupHandle(MarkupModelEx markupModel) {
        AsyncEntityHandle asyncEntityHandle;
        if (this.isEnabled()) {
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                AsyncEntityHandle asyncEntityHandle2 = (AsyncEntityHandle)markupModel.getUserData(MARKUP_ENTITY_HANDLE_KEY);
                asyncEntityHandle = asyncEntityHandle2;
            }
            finally {
                lock.unlock();
            }
        } else {
            asyncEntityHandle = null;
        }
        return asyncEntityHandle;
    }

    private final boolean isEnabled() {
        return RuntimeFlagsKt.isRhizomeAdEnabled();
    }

    static {
        Key key = Key.create((String)"AD_MARKUP_ENTITY_HANDLE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MARKUP_ENTITY_HANDLE_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl$AdDocumentMarkupListener;", "Lcom/intellij/openapi/editor/impl/DocumentMarkupListener;", "<init>", "()V", "markupModelCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "markupModelDisposed", "intellij.platform.ide.impl"})
    private static final class AdDocumentMarkupListener
    implements DocumentMarkupListener {
        public void markupModelCreated(@Nullable Project project2, @NotNull MarkupModelEx markupModel) {
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Companion.getInstance().createDocMarkupEntity(project2, markupModel);
        }

        public void markupModelDisposed(@Nullable Project project2, @NotNull MarkupModelEx markupModel) {
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Companion.getInstance().deleteDocMarkupEntity(markupModel);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl$Companion;", "", "<init>", "()V", "MARKUP_ENTITY_HANDLE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/impl/ad/util/AsyncEntityHandle;", "Lcom/intellij/openapi/editor/impl/ad/markup/AdMarkupEntity;", "getInstance", "Lcom/intellij/openapi/editor/impl/ad/markup/AdDocumentMarkupManagerImpl;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final AdDocumentMarkupManagerImpl getInstance() {
            AdDocumentMarkupManager adDocumentMarkupManager = AdDocumentMarkupManager.Companion.getInstance();
            Intrinsics.checkNotNull((Object)adDocumentMarkupManager, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.ad.markup.AdDocumentMarkupManagerImpl");
            return (AdDocumentMarkupManagerImpl)adDocumentMarkupManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

