/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.ui;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineColors;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineShadowPainter;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J0\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowBorder;", "Ljavax/swing/border/LineBorder;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "colors", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors;", "shadowPainter", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowPainter;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors;Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowPainter;)V", "borderHeight", "", "getLineColor", "Ljava/awt/Color;", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "insets", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "paintLineBorder", "shadowHeight", "isShadowEnabled", "intellij.platform.ide.impl"})
public final class StickyLineShadowBorder
extends LineBorder {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final StickyLineColors colors;
    @NotNull
    private final StickyLineShadowPainter shadowPainter;

    public StickyLineShadowBorder(@NotNull EditorEx editor2, @NotNull StickyLineColors colors, @NotNull StickyLineShadowPainter shadowPainter) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)shadowPainter, (String)"shadowPainter");
        super(null, 1);
        this.editor = editor2;
        this.colors = colors;
        this.shadowPainter = shadowPainter;
    }

    public final int borderHeight() {
        return this.thickness + this.shadowHeight();
    }

    @Override
    @NotNull
    public Color getLineColor() {
        return this.colors.borderLineColor();
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@Nullable Component c, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        insets.set(0, 0, this.thickness, 0);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.paintLineBorder(g, x, y, width, height);
        if (this.isShadowEnabled()) {
            this.shadowPainter.paintShadow((Graphics2D)g, x, y, width, height, this.shadowHeight());
        }
    }

    private final void paintLineBorder(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getLineColor());
        g.fillRect(x, y + (height - this.borderHeight()), width, this.thickness);
        g.setColor(oldColor);
    }

    private final int shadowHeight() {
        return this.isShadowEnabled() ? (int)(this.colors.heightFactor() * (double)this.editor.getLineHeight()) : 0;
    }

    private final boolean isShadowEnabled() {
        return Registry.Companion.is("editor.show.sticky.lines.shadow", true);
    }
}

