/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShlObj;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class GotoDesktopDirAction
extends FileChooserAction
implements LightEditCompatible {
    private final NullableLazyValue<Path> myDesktopPath = NullableLazyValue.lazyNullable(() -> {
        Path path = GotoDesktopDirAction.getDesktopDirectory();
        return Files.isDirectory(path, new LinkOption[0]) ? path : null;
    });
    private final NullableLazyValue<VirtualFile> myDesktopDirectory = NullableLazyValue.lazyNullable(() -> {
        Path path = (Path)this.myDesktopPath.getValue();
        return path != null ? LocalFileSystem.getInstance().findFileByNioFile(path) : null;
    });

    GotoDesktopDirAction() {
    }

    @Override
    protected void update(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        if (panel2 == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(1);
        }
        Path path = (Path)this.myDesktopPath.getValue();
        e.getPresentation().setEnabled(path != null);
    }

    @Override
    protected void actionPerformed(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        Path path;
        if (panel2 == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(3);
        }
        if ((path = (Path)this.myDesktopPath.getValue()) != null) {
            panel2.load(path);
        }
    }

    @Override
    protected void update(@NotNull FileSystemTree tree2, @NotNull AnActionEvent e) {
        if (tree2 == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(5);
        }
        VirtualFile dir = (VirtualFile)this.myDesktopDirectory.getValue();
        e.getPresentation().setEnabled(dir != null && tree2.isUnderRoots(dir));
    }

    @Override
    protected void actionPerformed(@NotNull FileSystemTree tree2, @NotNull AnActionEvent e) {
        VirtualFile dir;
        if (tree2 == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            GotoDesktopDirAction.$$$reportNull$$$0(7);
        }
        if ((dir = (VirtualFile)this.myDesktopDirectory.getValue()) != null) {
            tree2.select(dir, () -> tree2.expand(dir, null));
        }
    }

    private static Path getDesktopDirectory() {
        String path;
        if (OS.CURRENT == OS.Windows && JnaLoader.isLoaded()) {
            char[] path2 = new char[260];
            WinNT.HRESULT res = Shell32.INSTANCE.SHGetFolderPath(null, 0, null, ShlObj.SHGFP_TYPE_CURRENT, path2);
            if (WinError.S_OK.equals((Object)res)) {
                int len;
                for (len = 0; len < path2.length && path2[len] != '\u0000'; ++len) {
                }
                return Path.of(new String(path2, 0, len), new String[0]);
            }
        } else if (OS.CURRENT == OS.macOS && JnaLoader.isLoaded()) {
            String selector;
            ID manager2 = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSFileManager"), (String)"defaultManager", (Object[])new Object[0]);
            ID url = Foundation.invoke((ID)manager2, (String)(selector = "URLForDirectory:inDomain:appropriateForURL:create:error:"), (Object[])new Object[]{12, 1, null, false, null});
            String path3 = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)url, (String)"path", (Object[])new Object[0]));
            if (path3 != null) {
                return Path.of(path3, new String[0]);
            }
        } else if (OS.isGenericUnix() && PathEnvironmentVariableUtil.isOnPath((String)"xdg-user-dir") && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-user-dir", "DESKTOP"}))) != null && !path.isBlank()) {
            try {
                return Path.of(path, new String[0]);
            }
            catch (InvalidPathException e) {
                Logger.getInstance(GotoDesktopDirAction.class).error("str='" + path + "' JNU=" + System.getProperty("sun.jnu.encoding"), (Throwable)e);
            }
        }
        return Path.of(SystemProperties.getUserHome(), "Desktop");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/GotoDesktopDirAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

