/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EdtInvocationManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    private static final Logger LOG = Logger.getInstance(BackgroundableProcessIndicator.class);
    private StatusBarEx myStatusBar;
    private TaskInfo myInfo;
    private boolean myDidInitializeOnEdt;
    private boolean myDisposed;

    @ApiStatus.Obsolete
    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(0);
        }
        this(task.getProject(), (TaskInfo)task);
    }

    @Deprecated(forRemoval=true)
    public BackgroundableProcessIndicator(@Nullable Project project2, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(1);
        }
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(2);
        }
        this(project2, info);
    }

    @ApiStatus.Obsolete
    public BackgroundableProcessIndicator(@Nullable Project project2, @NotNull TaskInfo info) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(3);
        }
        this(project2, info, (StatusBarEx)null);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public BackgroundableProcessIndicator(@Nullable Project project2, @NotNull TaskInfo info, @Nullable StatusBarEx statusBarOverride) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(4);
        }
        super(info.isCancellable(), true, project2, null, info.getCancelText());
        this.setOwnerTask(info);
        this.myInfo = info;
        this.myStatusBar = statusBarOverride;
        this.myBackgrounded = true;
        EdtInvocationManager.invokeLaterIfNeeded(this::initializeStatusBar);
    }

    @Override
    @RequiresEdt
    protected void initializeOnEdtIfNeeded() {
        ThreadingAssertions.assertEventDispatchThread();
        super.initializeOnEdtIfNeeded();
        this.initializeStatusBar();
    }

    @RequiresEdt
    private void initializeStatusBar() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDisposed || this.myDidInitializeOnEdt) {
            return;
        }
        this.myDidInitializeOnEdt = true;
        this.setTitle(this.myInfo.getTitle());
        if (this.myStatusBar == null) {
            Project nonDefaultProject = this.myProject == null || this.myProject.isDisposed() || this.myProject.isDefault() ? null : this.myProject;
            IdeFrameEx frame = WindowManagerEx.getInstanceEx().findFrameHelper(nonDefaultProject);
            StatusBarEx statusBarEx = this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
            if (this.myStatusBar == null && LOG.isDebugEnabled()) {
                LOG.debug("No status bar for [" + String.valueOf((Object)this) + "], progress will be displayed in a popup\nproject:" + String.valueOf(this.myProject) + "\nframe:" + String.valueOf(frame), new Throwable());
            }
        }
        this.doBackground(this.myStatusBar);
    }

    @Deprecated
    public BackgroundableProcessIndicator(@Nullable Project project2, @NlsContexts.ProgressTitle String progressTitle, @NotNull PerformInBackgroundOption option2, @NlsContexts.Button @Nullable String cancelButtonText, @NlsContexts.Tooltip String backgroundStopTooltip, boolean cancellable) {
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(5);
        }
        this(project2, progressTitle, cancelButtonText, backgroundStopTooltip, cancellable);
    }

    public BackgroundableProcessIndicator(@Nullable Project project2, final @NlsContexts.ProgressTitle String progressTitle, final @NlsContexts.Button @Nullable String cancelButtonText, final @NlsContexts.Tooltip String backgroundStopTooltip, final boolean cancellable) {
        this(project2, new TaskInfo(){

            @NotNull
            public String getTitle() {
                String string = progressTitle;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator$1", "getTitle"));
            }
        });
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        this.initializeOnEdtIfNeeded();
        if (this.myStatusBar != null) {
            return;
        }
        super.showDialog();
    }

    @TestOnly
    @ApiStatus.Internal
    public void showDialogTestAccessor() {
        this.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        assert (this.myDidInitializeOnEdt) : "Call to background action before showing dialog";
        this.doBackground(this.myStatusBar);
        super.background();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void doBackground(@Nullable StatusBarEx statusBarEx) {
        void statusBar;
        ThreadingAssertions.assertEventDispatchThread();
        if (statusBar != null) {
            statusBar.addProgress((ProgressIndicatorEx)this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
    }

    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + String.valueOf(this.myInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "option";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

