/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.EventStealer;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PotemkinProgress
extends ProgressWindow
implements PingProgress {
    private final Application myApp;
    private final EventStealer myEventStealer;
    private final PerformanceWatcher myWatcher;
    private long myLastUiUpdate;
    private long myLastInteraction;
    private long myLastWatcherPing;

    @ApiStatus.Obsolete
    public PotemkinProgress(@NlsContexts.ModalProgressTitle @NotNull String title2, @Nullable Project project2, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        if (title2 == null) {
            PotemkinProgress.$$$reportNull$$$0(0);
        }
        super(cancelText != null, false, project2, parentComponent, cancelText);
        this.myApp = ApplicationManager.getApplication();
        this.myWatcher = PerformanceWatcher.Companion.getInstanceIfCreated();
        this.myLastInteraction = this.myLastUiUpdate = System.currentTimeMillis();
        this.myLastWatcherPing = this.myLastUiUpdate;
        this.setTitle(title2);
        ThreadingAssertions.assertEventDispatchThread();
        this.myApp.getService(DialogWrapperPeerFactory.class);
        this.myEventStealer = PotemkinProgress.startStealingInputEvents(this::dispatchInputEvent, this);
    }

    @NotNull
    static EventStealer startStealingInputEvents(@NotNull Consumer<? super InputEvent> inputConsumer, @NotNull Disposable parent) {
        if (inputConsumer == null) {
            PotemkinProgress.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            PotemkinProgress.$$$reportNull$$$0(2);
        }
        return new EventStealer(parent, inputConsumer);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public ProgressDialog getDialog() {
        ProgressDialog progressDialog = Objects.requireNonNull(super.getDialog());
        if (progressDialog == null) {
            PotemkinProgress.$$$reportNull$$$0(3);
        }
        return progressDialog;
    }

    public void interact() {
        if (!this.myApp.isDispatchThread()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now == this.myLastInteraction) {
            return;
        }
        this.myLastInteraction = now;
        if (this.myWatcher != null && now - this.myLastWatcherPing > (long)(this.myWatcher.getUnresponsiveInterval() / 2)) {
            this.myLastWatcherPing = now;
            this.myWatcher.edtEventStarted();
        }
        if (this.getDialog().getPanel().isShowing()) {
            this.myEventStealer.dispatchEvents(0);
        }
        this.updateUI(now);
    }

    private void dispatchInputEvent(@NotNull InputEvent e) {
        if (e == null) {
            PotemkinProgress.$$$reportNull$$$0(4);
        }
        if (this.isCancellationEvent(e)) {
            this.cancel();
            return;
        }
        Object source = e.getSource();
        if (source instanceof Component && this.isInDialogWindow((Component)source)) {
            ((Component)source).dispatchEvent(e);
        }
    }

    private boolean isInDialogWindow(Component source) {
        Window dialogWindow = SwingUtilities.windowForComponent(this.getDialog().getPanel());
        return dialogWindow instanceof JDialog && SwingUtilities.isDescendingFrom(source, dialogWindow);
    }

    private void updateUI(long now) {
        if (this.myApp.isUnitTestMode()) {
            if (now - this.myLastUiUpdate > (long)this.delayInMillis) {
                this.myEventStealer.dispatchAllExistingEvents();
                this.drainUndispatchedInputEvents();
            }
            return;
        }
        JRootPane rootPane = this.getDialog().getPanel().getRootPane();
        if (rootPane == null && now - this.myLastUiUpdate > (long)this.delayInMillis && this.myApp.isActive()) {
            this.getDialog().getRepaintRunnable().run();
            this.showDialog();
            this.drainUndispatchedInputEvents();
            rootPane = this.getDialog().getPanel().getRootPane();
        }
        if (rootPane != null && now - this.myLastUiUpdate > 50L) {
            this.myLastUiUpdate = now;
            this.paintProgress();
        }
    }

    void progressFinished() {
        this.getDialog().hideImmediately();
        this.myEventStealer.dispatchAllExistingEvents();
    }

    private void paintProgress() {
        this.getDialog().getRepaintRunnable().run();
        JPanel dialogPanel = this.getDialog().getPanel();
        dialogPanel.validate();
        dialogPanel.paintImmediately(dialogPanel.getBounds());
    }

    public void runInSwingThread(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            ProgressManager.getInstance().runProcess(action2, (ProgressIndicator)this);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.progressFinished();
        }
    }

    public void runInBackground(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            this.executeInModalContext(() -> {
                this.ensureBackgroundThreadStarted(action2);
                while (this.isRunning()) {
                    this.myEventStealer.dispatchEvents(10);
                    this.updateUI(System.currentTimeMillis());
                }
            });
        }
        finally {
            this.progressFinished();
        }
    }

    private void ensureBackgroundThreadStarted(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(7);
        }
        Semaphore started = new Semaphore();
        started.down();
        AppExecutorUtil.getAppExecutorService().execute(() -> ProgressManager.getInstance().runProcess(() -> {
            started.up();
            action2.run();
        }, (ProgressIndicator)this));
        started.waitFor();
    }

    private List<InputEvent> drainUndispatchedInputEvents() {
        return this.myEventStealer.drainUndispatchedInputEvents();
    }

    @ApiStatus.Internal
    public void dispatchAllInvocationEvents() {
        this.myEventStealer.dispatchAllExistingEvents();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startStealingInputEvents";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dispatchInputEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runInSwingThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureBackgroundThreadStarted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

