/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.project.DumbModeStatisticsCollector;
import com.intellij.openapi.project.MergeableQueueTask;
import com.intellij.openapi.project.MergingQueueGuiSuspender;
import com.intellij.openapi.project.MergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.SingleTaskExecutor;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0017\u0018\u0000 T*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0003RSTBA\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u0012\u000b\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J&\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-J\b\u0010.\u001a\u00020/H\u0016J\u001c\u00103\u001a\u00020+2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020+05H\u0002J\u001b\u00106\u001a\u00020/2\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0000\u00a2\u0006\u0002\b:J\u0018\u0010;\u001a\u00020+2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0=H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00020'H\u0002J \u0010?\u001a\u00020+2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000@2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0006\u0010H\u001a\u00020+J\u0014\u0010I\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-J\u001b\u0010J\u001a\u00020+2\u000b\u0010K\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\u0006\u0010(\u001a\u00020LJ\u0006\u0010M\u001a\u00020+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u0004\u0018\u00010\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020/0B\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010CR\u0015\u0010D\u001a\u0006\u0012\u0002\b\u00030E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010N\u001a\u00020O8G\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006U"}, d2={"Lcom/intellij/openapi/project/MergingQueueGuiExecutor;", "T", "Lcom/intellij/openapi/project/MergeableQueueTask;", "", "project", "Lcom/intellij/openapi/project/Project;", "taskQueue", "Lcom/intellij/openapi/project/MergingTaskQueue;", "listener", "Lcom/intellij/openapi/project/MergingQueueGuiExecutor$ExecutorStateListener;", "progressTitle", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "suspendedText", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/project/MergingTaskQueue;Lcom/intellij/openapi/project/MergingQueueGuiExecutor$ExecutorStateListener;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTaskQueue", "()Lcom/intellij/openapi/project/MergingTaskQueue;", "mySingleTaskExecutor", "Lcom/intellij/openapi/project/SingleTaskExecutor;", "mySuspended", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myListener", "guiSuspender", "Lcom/intellij/openapi/project/MergingQueueGuiSuspender;", "getGuiSuspender", "()Lcom/intellij/openapi/project/MergingQueueGuiSuspender;", "myProgressTitle", "mySuspendedText", "backgroundTasksSubmitted", "Ljava/util/concurrent/atomic/AtomicInteger;", "processTasksWithProgress", "Lcom/intellij/openapi/project/MergingTaskQueue$SubmissionReceipt;", "suspender", "Lcom/intellij/openapi/progress/impl/ProgressSuspender;", "visibleIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "startBackgroundProcess", "", "onFinish", "Lkotlin/Function0;", "shouldShowProgressIndicator", "", "taskId", "getTaskId", "()Ljava/lang/Object;", "startInBackgroundWithVisibleOrInvisibleProgress", "task", "Lkotlin/Function1;", "tryStartProcessInThisThread", "processRunner", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/project/SingleTaskExecutor$AutoclosableProgressive;", "tryStartProcessInThisThread$intellij_platform_ide_impl", "runWithCallbacks", "runnable", "Ljava/util/function/Supplier;", "runBackgroundProcessWithSuspender", "runSingleTask", "Lcom/intellij/openapi/project/MergingTaskQueue$QueuedTask;", "isRunning", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "startedOrStoppedEvent", "Lkotlinx/coroutines/flow/Flow;", "getStartedOrStoppedEvent", "()Lkotlinx/coroutines/flow/Flow;", "suspendQueue", "resumeQueue", "suspendAndRun", "activityName", "Ljava/lang/Runnable;", "cancelAllTasks", "backgroundTasksSubmittedCount", "", "getBackgroundTasksSubmittedCount", "()I", "ExecutorStateListener", "SafeExecutorStateListenerWrapper", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMergingQueueGuiExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergingQueueGuiExecutor.kt\ncom/intellij/openapi/project/MergingQueueGuiExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
public class MergingQueueGuiExecutor<T extends MergeableQueueTask<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MergingTaskQueue<T> taskQueue;
    @NotNull
    private final SingleTaskExecutor mySingleTaskExecutor;
    @NotNull
    private final AtomicBoolean mySuspended;
    @NotNull
    private final ExecutorStateListener myListener;
    @NotNull
    private final MergingQueueGuiSuspender guiSuspender;
    @NotNull
    private final String myProgressTitle;
    @NotNull
    private final String mySuspendedText;
    @NotNull
    private final AtomicInteger backgroundTasksSubmitted;
    @Nullable
    private final Object taskId;
    @NotNull
    private final StateFlow<Boolean> isRunning;
    @NotNull
    private final Flow<?> startedOrStoppedEvent;
    @NotNull
    private static final Logger LOG;

    protected MergingQueueGuiExecutor(@NotNull Project project2, @NotNull MergingTaskQueue<T> taskQueue, @NotNull ExecutorStateListener listener2, @NotNull String progressTitle, @NotNull String suspendedText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(taskQueue, (String)"taskQueue");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)suspendedText, (String)"suspendedText");
        this.project = project2;
        this.taskQueue = taskQueue;
        this.mySuspended = new AtomicBoolean();
        this.myListener = new SafeExecutorStateListenerWrapper(listener2);
        this.guiSuspender = new MergingQueueGuiSuspender();
        this.myProgressTitle = progressTitle;
        this.mySuspendedText = suspendedText;
        this.backgroundTasksSubmitted = new AtomicInteger(0);
        this.mySingleTaskExecutor = new SingleTaskExecutor(arg_0 -> MergingQueueGuiExecutor._init_$lambda$0(this, arg_0));
        this.isRunning = this.mySingleTaskExecutor.isRunning();
        this.startedOrStoppedEvent = (Flow)this.mySingleTaskExecutor.getModificationTrackerAsFlow();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MergingTaskQueue<T> getTaskQueue() {
        return this.taskQueue;
    }

    @NotNull
    protected final MergingQueueGuiSuspender getGuiSuspender() {
        return this.guiSuspender;
    }

    @Nullable
    public MergingTaskQueue.SubmissionReceipt processTasksWithProgress(@Nullable ProgressSuspender suspender, @NotNull ProgressIndicator visibleIndicator, @Nullable StructuredIdeActivity activity) {
        Intrinsics.checkNotNullParameter((Object)visibleIndicator, (String)"visibleIndicator");
        return this.guiSuspender.setCurrentSuspenderAndSuspendIfRequested(suspender, () -> MergingQueueGuiExecutor.processTasksWithProgress$lambda$0(this, visibleIndicator, suspender, activity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void startBackgroundProcess(@NotNull Function0<Unit> onFinish2) {
        boolean startedInBackground;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(onFinish2, (String)"onFinish");
                startedInBackground = false;
                try {
                    if (!this.mySuspended.get()) break block4;
                }
                catch (Throwable throwable) {
                    onFinish2.invoke();
                    throw throwable;
                }
                onFinish2.invoke();
                return;
            }
            if (!this.taskQueue.isEmpty()) break block5;
            onFinish2.invoke();
            return;
        }
        startedInBackground = this.mySingleTaskExecutor.tryStartProcess(arg_0 -> MergingQueueGuiExecutor.startBackgroundProcess$lambda$0(this, onFinish2, arg_0));
        if (startedInBackground) return;
        onFinish2.invoke();
    }

    public boolean shouldShowProgressIndicator() {
        return true;
    }

    @Nullable
    protected Object getTaskId() {
        return this.taskId;
    }

    private final void startInBackgroundWithVisibleOrInvisibleProgress(Function1<? super ProgressIndicator, Unit> task) {
        Project project2 = this.project;
        String string = this.myProgressTitle;
        Task.Backgroundable backgroundableTask2 = new Task.Backgroundable(task, this, project2, string){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $task;
            final /* synthetic */ MergingQueueGuiExecutor<T> this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(ProgressIndicator visibleIndicator) {
                Intrinsics.checkNotNullParameter((Object)visibleIndicator, (String)"visibleIndicator");
                this.$task.invoke((Object)visibleIndicator);
            }

            public Object getId() {
                return this.this$0.getTaskId();
            }

            public boolean isHeadless() {
                return false;
            }
        };
        if (this.shouldShowProgressIndicator()) {
            ProgressManager.getInstance().run((Task)backgroundableTask2);
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(backgroundableTask2, (ProgressIndicator)new EmptyProgressIndicator());
        }
    }

    public final boolean tryStartProcessInThisThread$intellij_platform_ide_impl(@NotNull Consumer<SingleTaskExecutor.AutoclosableProgressive> processRunner) {
        Intrinsics.checkNotNullParameter(processRunner, (String)"processRunner");
        return this.mySingleTaskExecutor.tryStartProcess(processRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runWithCallbacks(Supplier<MergingTaskQueue.SubmissionReceipt> runnable2) {
        boolean shouldProcessQueue = this.myListener.beforeFirstTask();
        if (shouldProcessQueue) {
            MergingTaskQueue.SubmissionReceipt receipt = null;
            try {
                receipt = runnable2.get();
            }
            finally {
                this.myListener.afterLastTask(receipt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MergingTaskQueue.SubmissionReceipt runBackgroundProcessWithSuspender(ProgressIndicator visibleIndicator) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        if (visibleIndicator instanceof UserDataHolder && progressManager2 instanceof ProgressManagerImpl) {
            ((ProgressManagerImpl)progressManager2).markProgressSafe((UserDataHolder)visibleIndicator);
        }
        AutoCloseable autoCloseable = ProgressSuspender.markSuspendable(visibleIndicator, this.mySuspendedText);
        Throwable throwable = null;
        try {
            ProgressSuspender suspender = (ProgressSuspender)autoCloseable;
            boolean bl = false;
            MergingTaskQueue.SubmissionReceipt submissionReceipt = this.processTasksWithProgress(suspender, visibleIndicator, null);
            return submissionReceipt;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public void runSingleTask(@NotNull MergingTaskQueue.QueuedTask<T> task, @Nullable StructuredIdeActivity activity) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        LOG.info("Running task: " + task.getInfoString());
        StructuredIdeActivity structuredIdeActivity = activity;
        StructuredIdeActivity stageActivity = structuredIdeActivity != null ? task.registerStageStarted(structuredIdeActivity, this.project) : null;
        ProgressManager.getInstance().runProcess(() -> MergingQueueGuiExecutor.runSingleTask$lambda$0(task, activity, stageActivity), (ProgressIndicator)task.getIndicator());
        LOG.info("Task finished: " + task.getInfoString());
    }

    @NotNull
    public final StateFlow<Boolean> isRunning() {
        return this.isRunning;
    }

    @NotNull
    public final Flow<?> getStartedOrStoppedEvent() {
        return this.startedOrStoppedEvent;
    }

    public final void suspendQueue() {
        this.mySuspended.set(true);
        this.mySingleTaskExecutor.clearScheduledFlag();
    }

    public final void resumeQueue(@NotNull Function0<Unit> onFinish2) {
        Intrinsics.checkNotNullParameter(onFinish2, (String)"onFinish");
        if (this.mySuspended.compareAndSet(true, false) && !this.taskQueue.isEmpty()) {
            this.startBackgroundProcess(onFinish2);
        }
    }

    public final void suspendAndRun(@NotNull String activityName, @NotNull Runnable activity) {
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.guiSuspender.suspendAndRun(activityName, activity);
    }

    public final void cancelAllTasks() {
        this.taskQueue.cancelAllTasks();
        this.guiSuspender.resumeProgressIfPossible();
    }

    @TestOnly
    public final int getBackgroundTasksSubmittedCount() {
        return this.backgroundTasksSubmitted.get();
    }

    private static final MergingTaskQueue.SubmissionReceipt lambda$0$0(MergingQueueGuiExecutor this$0, ProgressIndicator $visibleIndicator) {
        return this$0.runBackgroundProcessWithSuspender($visibleIndicator);
    }

    private static final void _init_$lambda$0(MergingQueueGuiExecutor this$0, ProgressIndicator visibleIndicator) {
        Intrinsics.checkNotNullParameter((Object)visibleIndicator, (String)"visibleIndicator");
        this$0.runWithCallbacks(() -> MergingQueueGuiExecutor.lambda$0$0(this$0, visibleIndicator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MergingTaskQueue.SubmissionReceipt processTasksWithProgress$lambda$0(MergingQueueGuiExecutor this$0, ProgressIndicator $visibleIndicator, ProgressSuspender $suspender, StructuredIdeActivity $activity) {
        while (!this$0.project.isDisposed()) {
            if (this$0.mySuspended.get()) {
                return null;
            }
            MergingTaskQueue.SubmissionReceipt submittedTaskCount = this$0.taskQueue.getLatestSubmissionReceipt();
            this$0.mySingleTaskExecutor.clearScheduledFlag();
            AutoCloseable autoCloseable = this$0.taskQueue.extractNextTask();
            Throwable throwable = null;
            try {
                MergingTaskQueue.QueuedTask task = (MergingTaskQueue.QueuedTask)autoCloseable;
                boolean bl = false;
                if (task == null) {
                    MergingTaskQueue.SubmissionReceipt submissionReceipt = submittedTaskCount;
                    return submissionReceipt;
                }
                ProgressIndicatorEx progressIndicatorEx = task.getIndicator();
                Intrinsics.checkNotNull((Object)progressIndicatorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase");
                AbstractProgressIndicatorExBase taskIndicator = (AbstractProgressIndicatorExBase)progressIndicatorEx;
                ProgressIndicatorEx relayToVisibleIndicator = (ProgressIndicatorEx)new RelayUiToDelegateIndicator($visibleIndicator);
                ProgressSuspender progressSuspender = $suspender;
                if (progressSuspender != null) {
                    progressSuspender.attachToProgress((ProgressIndicatorEx)taskIndicator);
                }
                taskIndicator.addStateDelegate(relayToVisibleIndicator);
                try {
                    this$0.runSingleTask(task, $activity);
                }
                finally {
                    taskIndicator.removeStateDelegate(relayToVisibleIndicator);
                }
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startBackgroundProcess$lambda$0$0(SingleTaskExecutor.AutoclosableProgressive $task, Function0 $onFinish, ProgressIndicator visibleOrInvisibleIndicator) {
        Intrinsics.checkNotNullParameter((Object)visibleOrInvisibleIndicator, (String)"visibleOrInvisibleIndicator");
        try {
            AutoCloseable autoCloseable = $task;
            Throwable throwable = null;
            try {
                SingleTaskExecutor.AutoclosableProgressive it = (SingleTaskExecutor.AutoclosableProgressive)autoCloseable;
                boolean bl = false;
                it.run(visibleOrInvisibleIndicator);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            LOG.error("Failed to execute background index update task", t);
        }
        finally {
            $onFinish.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final void startBackgroundProcess$lambda$0(MergingQueueGuiExecutor this$0, Function0 $onFinish, SingleTaskExecutor.AutoclosableProgressive task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            if (this$0.mySuspended.get()) {
                return;
            }
            this$0.backgroundTasksSubmitted.incrementAndGet();
            this$0.startInBackgroundWithVisibleOrInvisibleProgress((Function1<ProgressIndicator, Unit>)((Function1)arg_0 -> MergingQueueGuiExecutor.startBackgroundProcess$lambda$0$0(task, $onFinish, arg_0)));
        }
        catch (ProcessCanceledException pce) {
            task.close();
            $onFinish.invoke();
            throw pce;
        }
        catch (Throwable t) {
            task.close();
            this$0.mySingleTaskExecutor.clearScheduledFlag();
            $onFinish.invoke();
            LOG.error("Failed to start background index update task", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void runSingleTask$lambda$0(MergingTaskQueue.QueuedTask $task, StructuredIdeActivity $activity, StructuredIdeActivity $stageActivity) {
        DumbModeStatisticsCollector.IndexingFinishType taskFinishType = DumbModeStatisticsCollector.IndexingFinishType.TERMINATED;
        try {
            $task.executeTask();
            taskFinishType = DumbModeStatisticsCollector.IndexingFinishType.FINISHED;
        }
        catch (ProcessCanceledException processCanceledException) {
            LOG.info("Task canceled (PCE): " + $task.getInfoString());
        }
        catch (Throwable unexpected) {
            LOG.error("Failed to execute task " + $task.getInfoString() + ". " + unexpected.getMessage(), unexpected);
        }
        finally {
            if ($activity != null) {
                $task.registerStageFinished($activity, $stageActivity, taskFinishType);
            }
        }
    }

    static {
        Logger logger2 = Logger.getInstance(MergingQueueGuiExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/project/MergingQueueGuiExecutor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/MergingQueueGuiExecutor$ExecutorStateListener;", "", "beforeFirstTask", "", "afterLastTask", "", "latestReceipt", "Lcom/intellij/openapi/project/MergingTaskQueue$SubmissionReceipt;", "intellij.platform.ide.impl"})
    @ApiStatus.Experimental
    public static interface ExecutorStateListener {
        public boolean beforeFirstTask();

        public void afterLastTask(@Nullable MergingTaskQueue.SubmissionReceipt var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/project/MergingQueueGuiExecutor$SafeExecutorStateListenerWrapper;", "Lcom/intellij/openapi/project/MergingQueueGuiExecutor$ExecutorStateListener;", "delegate", "<init>", "(Lcom/intellij/openapi/project/MergingQueueGuiExecutor$ExecutorStateListener;)V", "beforeFirstTask", "", "afterLastTask", "", "latestReceipt", "Lcom/intellij/openapi/project/MergingTaskQueue$SubmissionReceipt;", "intellij.platform.ide.impl"})
    private static final class SafeExecutorStateListenerWrapper
    implements ExecutorStateListener {
        @NotNull
        private final ExecutorStateListener delegate;

        public SafeExecutorStateListenerWrapper(@NotNull ExecutorStateListener delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @Override
        public boolean beforeFirstTask() {
            boolean bl;
            try {
                bl = this.delegate.beforeFirstTask();
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                bl = false;
            }
            return bl;
        }

        @Override
        public void afterLastTask(@Nullable MergingTaskQueue.SubmissionReceipt latestReceipt) {
            try {
                this.delegate.afterLastTask(latestReceipt);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

