/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017R\u0014\u0010\u0019\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "", "<init>", "()V", "forceEapUpdateChannelForEapBuilds", "", "changeDefaultChannel", "Lcom/intellij/openapi/updateSettings/impl/ChannelStatus;", "currentChannel", "isChannelActive", "channel", "haveSameMajorVersion", "build1", "Lcom/intellij/openapi/util/BuildNumber;", "build2", "isNewerVersion", "candidateBuild", "currentBuild", "isChannelApplicableForUpdates", "updateChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "selectedChannel", "canBeUsedForIntermediatePatches", "getChannelSelectionLockedMessage", "", "showWhatIsNewPageAfterUpdate", "getShowWhatIsNewPageAfterUpdate", "()Z", "Companion", "intellij.platform.ide.impl"})
public class UpdateStrategyCustomization {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean forceEapUpdateChannelForEapBuilds() {
        return true;
    }

    @Nullable
    public ChannelStatus changeDefaultChannel(@NotNull ChannelStatus currentChannel) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentChannel), (String)"currentChannel");
        return null;
    }

    public boolean isChannelActive(@NotNull ChannelStatus channel) {
        Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
        return channel != ChannelStatus.MILESTONE && channel != ChannelStatus.BETA;
    }

    public boolean haveSameMajorVersion(@NotNull BuildNumber build1, @NotNull BuildNumber build2) {
        Intrinsics.checkNotNullParameter((Object)build1, (String)"build1");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build2");
        return build1.getBaselineVersion() == build2.getBaselineVersion();
    }

    public boolean isNewerVersion(@NotNull BuildNumber candidateBuild, @NotNull BuildNumber currentBuild) {
        Intrinsics.checkNotNullParameter((Object)candidateBuild, (String)"candidateBuild");
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        return candidateBuild.compareTo(currentBuild) > 0;
    }

    public boolean isChannelApplicableForUpdates(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        Intrinsics.checkNotNullParameter((Object)updateChannel, (String)"updateChannel");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedChannel), (String)"selectedChannel");
        return updateChannel.getStatus().compareTo((Enum)selectedChannel) >= 0;
    }

    public boolean canBeUsedForIntermediatePatches(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        Intrinsics.checkNotNullParameter((Object)updateChannel, (String)"updateChannel");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedChannel), (String)"selectedChannel");
        return true;
    }

    @NlsContexts.DetailedDescription
    @Nullable
    public String getChannelSelectionLockedMessage() {
        return ApplicationInfoEx.getInstanceEx().isMajorEAP() && this.forceEapUpdateChannelForEapBuilds() ? IdeBundle.message((String)"updates.settings.channel.locked", (Object[])new Object[0]) : null;
    }

    public boolean getShowWhatIsNewPageAfterUpdate() {
        return false;
    }

    @JvmStatic
    @NotNull
    public static final UpdateStrategyCustomization getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nUpdateStrategyCustomization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateStrategyCustomization.kt\ncom/intellij/openapi/updateSettings/UpdateStrategyCustomization$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,95:1\n42#2,3:96\n*S KotlinDebug\n*F\n+ 1 UpdateStrategyCustomization.kt\ncom/intellij/openapi/updateSettings/UpdateStrategyCustomization$Companion\n*L\n18#1:96,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UpdateStrategyCustomization getInstance() {
            boolean $i$f$service = false;
            Class<UpdateStrategyCustomization> serviceClass$iv = UpdateStrategyCustomization.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (UpdateStrategyCustomization)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

