/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.Processor;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FSRecords {
    static final Logger LOG = Logger.getInstance(FSRecords.class);
    static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.SECONDS.toMillis(30L));
    public static final String IDE_USE_FS_ROOTS_DATA_LOADER = "idea.fs.roots.data.loader";
    public static final int NULL_FILE_ID = 0;
    public static final int ROOT_FILE_ID = 1;
    public static final int MIN_REGULAR_FILE_ID = 2;
    private static volatile FSRecordsImpl impl;

    @NotNull
    public static Path getCacheDir() {
        String dir = System.getProperty("caches_dir");
        Path path = dir == null ? Path.of(PathManager.getSystemPath(), "caches") : Path.of(dir, new String[0]);
        if (path == null) {
            FSRecords.$$$reportNull$$$0(0);
        }
        return path;
    }

    private FSRecords() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    public static synchronized FSRecordsImpl connect() throws UncheckedIOException {
        return FSRecords.connect(FSRecordsImpl.defaultErrorHandler());
    }

    public static synchronized FSRecordsImpl connect(@NotNull FSRecordsImpl.ErrorHandler errorHandler) throws UncheckedIOException {
        FSRecordsImpl _impl;
        FSRecordsImpl oldImpl;
        if (errorHandler == null) {
            FSRecords.$$$reportNull$$$0(1);
        }
        if ((oldImpl = impl) != null && !oldImpl.isClosed()) {
            throw new IllegalStateException("Can't connect default VFS instance -- default VFS instance is already set up and not yet disposed. Current instance: " + String.valueOf(oldImpl));
        }
        impl = _impl = FSRecordsImpl.connect(FSRecords.getCacheDir(), errorHandler);
        return _impl;
    }

    @NotNull
    private static FSRecordsImpl implOrFail() {
        FSRecordsImpl _impl = impl;
        if (_impl == null) {
            throw new ServiceNotReadyException("VFS instance is not initialized yet");
        }
        if (_impl.isClosed()) {
            _impl.checkNotClosed();
        }
        FSRecordsImpl fSRecordsImpl = _impl;
        if (fSRecordsImpl == null) {
            FSRecords.$$$reportNull$$$0(2);
        }
        return fSRecordsImpl;
    }

    @NotNull
    public static FSRecordsImpl getInstance() throws AlreadyDisposedException {
        return FSRecords.implOrFail();
    }

    @Nullable
    static FSRecordsImpl getInstanceIfCreatedAndNotDisposed() {
        FSRecordsImpl _impl = impl;
        return _impl == null || _impl.isClosed() ? null : _impl;
    }

    public static long getCreationTimestamp() {
        return FSRecords.getInstance().getCreationTimestamp();
    }

    @Deprecated(forRemoval=true)
    public static long getNamesIndexModCount() {
        return FSRecords.implOrFail().getInvertedNameIndexModCount();
    }

    @Deprecated(forRemoval=true)
    public static int createRecord() {
        return FSRecords.implOrFail().createRecord();
    }

    @NotNull
    public static IntList getRemainFreeRecords() {
        IntList intList = FSRecords.implOrFail().getRemainFreeRecords();
        if (intList == null) {
            FSRecords.$$$reportNull$$$0(3);
        }
        return intList;
    }

    @NotNull
    public static IntList getNewFreeRecords() {
        IntList intList = FSRecords.implOrFail().getNewFreeRecords();
        if (intList == null) {
            FSRecords.$$$reportNull$$$0(4);
        }
        return intList;
    }

    public static boolean processAllNames(@NotNull Processor<? super CharSequence> processor2) {
        if (processor2 == null) {
            FSRecords.$$$reportNull$$$0(5);
        }
        return FSRecords.implOrFail().processAllNames(processor2);
    }

    public static boolean processFilesWithNames(@NotNull Set<String> names, @NotNull IntPredicate processor2) {
        if (names == null) {
            FSRecords.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            FSRecords.$$$reportNull$$$0(7);
        }
        return FSRecords.implOrFail().processFilesWithNames(names, processor2);
    }

    @Deprecated(forRemoval=true)
    static long getLength(int fileId) {
        return FSRecords.implOrFail().getLength(fileId);
    }

    @Deprecated(forRemoval=true)
    static void setLength(int fileId, long length) {
        FSRecords.implOrFail().setLength(fileId, length);
    }

    @Deprecated(forRemoval=true)
    static long getTimestamp(int fileId) {
        return FSRecords.implOrFail().getTimestamp(fileId);
    }

    @Deprecated(forRemoval=true)
    static void setTimestamp(int fileId, long value) {
        FSRecords.implOrFail().setTimestamp(fileId, value);
    }

    @Nullable
    public static AttributeInputStream readAttributeWithLock(int fileId, @NotNull FileAttribute attribute) {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(8);
        }
        return FSRecords.implOrFail().readAttribute(fileId, attribute);
    }

    @NotNull
    public static AttributeOutputStream writeAttribute(int fileId, @NotNull FileAttribute attribute) {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(9);
        }
        AttributeOutputStream attributeOutputStream = FSRecords.implOrFail().writeAttribute(fileId, attribute);
        if (attributeOutputStream == null) {
            FSRecords.$$$reportNull$$$0(10);
        }
        return attributeOutputStream;
    }

    public static boolean supportsRawAttributesAccess() {
        return FSRecords.implOrFail().supportsRawAttributesAccess();
    }

    @ApiStatus.Internal
    @Nullable
    public static <R> R readAttributeRawWithLock(int fileId, @NotNull FileAttribute attribute, ByteBufferReader<R> reader) {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(11);
        }
        return FSRecords.implOrFail().readAttributeRaw(fileId, attribute, reader);
    }

    public static void invalidateCaches(@NotNull String diagnosticMessage, @NotNull Throwable errorCause) {
        if (diagnosticMessage == null) {
            FSRecords.$$$reportNull$$$0(12);
        }
        if (errorCause == null) {
            FSRecords.$$$reportNull$$$0(13);
        }
        FSRecords.implOrFail().scheduleRebuild(diagnosticMessage, errorCause);
    }

    public static void invalidateCaches(@NotNull String diagnosticMessage) {
        if (diagnosticMessage == null) {
            FSRecords.$$$reportNull$$$0(14);
        }
        FSRecords.implOrFail().scheduleRebuild(diagnosticMessage, null);
    }

    @Deprecated
    @ApiStatus.Obsolete
    public static void invalidateCaches() {
        FSRecords.invalidateCaches("No description given");
    }

    @Contract(value="_->fail")
    public static RuntimeException handleError(Throwable e) throws RuntimeException, Error {
        return FSRecords.implOrFail().handleError(e);
    }

    @TestOnly
    public static void checkFilenameIndexConsistency() {
        FSRecordsImpl _impl = impl;
        if (_impl != null && !_impl.isClosed()) {
            _impl.checkFilenameIndexConsistency();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7, 8, 9, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticMessage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDir";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "implOrFail";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainFreeRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAllNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeWithLock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeRawWithLock";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCaches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 7, 8, 9, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

