/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.headertoolbar;

import com.intellij.ide.ProjectWidgetGradientLocationService;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import com.intellij.openapi.wm.impl.headertoolbar.ProjectToolbarWidgetActionKt;
import com.intellij.openapi.wm.impl.headertoolbar.WidgetPositionListeners;
import com.intellij.ui.ClientProperty;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0002\t\f\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners;", "", "widget", "Lcom/intellij/openapi/wm/impl/ToolbarComboButton;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolbarComboButton;Lcom/intellij/openapi/actionSystem/Presentation;)V", "componentListener", "com/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners$componentListener$1", "Lcom/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners$componentListener$1;", "hierarchyBoundsListener", "com/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners$hierarchyBoundsListener$1", "Lcom/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners$hierarchyBoundsListener$1;", "propertyChangeListener", "Ljava/beans/PropertyChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "", "setProjectFromPresentation", "updatePosition", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProjectToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectToolbarWidgetAction.kt\ncom/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,512:1\n30#2,2:513\n30#2,2:515\n*S KotlinDebug\n*F\n+ 1 ProjectToolbarWidgetAction.kt\ncom/intellij/openapi/wm/impl/headertoolbar/WidgetPositionListeners\n*L\n289#1:513,2\n306#1:515,2\n*E\n"})
final class WidgetPositionListeners {
    @NotNull
    private final ToolbarComboButton widget;
    @NotNull
    private final componentListener.1 componentListener;
    @NotNull
    private final hierarchyBoundsListener.1 hierarchyBoundsListener;
    @NotNull
    private final PropertyChangeListener propertyChangeListener;
    @Nullable
    private Project project;

    public WidgetPositionListeners(@NotNull ToolbarComboButton widget2, @NotNull Presentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.widget = widget2;
        this.componentListener = new ComponentAdapter(this){
            final /* synthetic */ WidgetPositionListeners this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                this.this$0.updatePosition();
            }

            public void componentMoved(ComponentEvent e) {
                this.this$0.updatePosition();
            }
        };
        this.hierarchyBoundsListener = new HierarchyBoundsListener(this){
            final /* synthetic */ WidgetPositionListeners this$0;
            {
                this.this$0 = $receiver;
            }

            public void ancestorMoved(HierarchyEvent e) {
                this.this$0.updatePosition();
            }

            public void ancestorResized(HierarchyEvent e) {
                this.this$0.updatePosition();
            }
        };
        this.propertyChangeListener = arg_0 -> WidgetPositionListeners.propertyChangeListener$lambda$0(this, arg_0);
        this.setProjectFromPresentation(presentation2);
        ClientProperty.put((JComponent)this.widget, (Key)ProjectToolbarWidgetActionKt.access$getWidgetPositionListenersKey$p(), (Object)this);
        this.widget.addComponentListener(this.componentListener);
        this.widget.addHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.widget.addPropertyChangeListener(this.propertyChangeListener);
    }

    public final void dispose() {
        this.widget.removePropertyChangeListener(this.propertyChangeListener);
        this.widget.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.widget.removeComponentListener(this.componentListener);
        ClientProperty.remove((JComponent)this.widget, (Key)ProjectToolbarWidgetActionKt.access$getWidgetPositionListenersKey$p());
        Object object = this.project;
        if (object != null) {
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<ProjectWidgetGradientLocationService> serviceClass$iv = ProjectWidgetGradientLocationService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (ProjectWidgetGradientLocationService)object2;
            if (object != null) {
                ((ProjectWidgetGradientLocationService)object).setProjectWidgetIconCenterRelativeToRootPane(null);
            }
        }
        this.project = null;
    }

    public final void setProjectFromPresentation(@NotNull Presentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Project oldProject = this.project;
        this.project = (Project)presentation2.getClientProperty(ProjectToolbarWidgetActionKt.access$getProjectKey$p());
        if (oldProject == null && this.project != null) {
            this.updatePosition();
        }
    }

    public final void updatePosition() {
        block2: {
            Icon icon2 = (Icon)CollectionsKt.firstOrNull(this.widget.getLeftIcons());
            float projectIconWidth = icon2 != null ? (float)icon2.getIconWidth() : 0.0f;
            ToolbarComboButton it = this.widget;
            boolean bl = false;
            float offset = (float)SwingUtilities.convertPoint((Component)((Component)it.getParent()), (int)it.getX(), (int)it.getY(), (Component)((Component)this.widget.getRootPane())).x + (float)it.getMargin().left + projectIconWidth / (float)2;
            Object object = this.project;
            if (object == null) break block2;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<ProjectWidgetGradientLocationService> serviceClass$iv = ProjectWidgetGradientLocationService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (ProjectWidgetGradientLocationService)object2;
            if (object != null) {
                ((ProjectWidgetGradientLocationService)object).setProjectWidgetIconCenterRelativeToRootPane(Float.valueOf(offset));
            }
        }
    }

    private static final void propertyChangeListener$lambda$0(WidgetPositionListeners this$0, PropertyChangeEvent e) {
        if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"leftIcons")) {
            this$0.updatePosition();
        }
    }
}

