/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.io.DigestUtilKt;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "writeIcons", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "safeHashValue", "", "value", "writeServiceStats", "intellij.platform.diagnostic.startUpPerformanceReporter"})
@SourceDebugExtension(value={"SMAP\nIdeIdeaFormatWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeIdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 jackson.kt\ncom/intellij/util/io/jackson/JacksonUtil\n*L\n1#1,217:1\n13#2:218\n21#3,5:219\n11#3,8:224\n26#3,2:232\n12#3,5:234\n12#3,7:239\n17#3,2:246\n21#3,5:248\n11#3,8:253\n26#3,2:261\n*S KotlinDebug\n*F\n+ 1 IdeIdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt\n*L\n32#1:218\n151#1:219,5\n153#1:224,8\n151#1:232,2\n191#1:234,5\n194#1:239,7\n191#1:246,2\n202#1:248,5\n209#1:253,8\n202#1:261,2\n*E\n"})
public final class IdeIdeaFormatWriterKt {
    private static final Logger getLogger() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(StartUpMeasurer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeIcons(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "icons";
        boolean $i$f$array = false;
        String it$iv = fieldName$iv;
        boolean bl = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl2 = false;
        for (IconLoadMeasurer.Counter stat2 : IconLoadMeasurer.INSTANCE.getStats()) {
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv2 = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl3 = false;
            writer.writeStringField("name", stat2.name);
            writer.writeNumberField("count", stat2.getCount());
            writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(stat2.getTotalDuration()));
            $this$obj_u24default$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    private static final String safeHashValue(String value) {
        MessageDigest messageDigest = DigestUtilKt.sha3_512();
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        byte[] byArray3 = byArray2;
        int n = 20;
        byte[] byArray4 = Arrays.copyOf(byArray3, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"copyOf(...)");
        byte[] result2 = byArray4;
        String string2 = Base64.getUrlEncoder().withoutPadding().encodeToString(result2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeServiceStats(JsonGenerator writer) {
        void $this$array$iv;
        ClassLoader $this$obj$iv;
        JsonGenerator $this$obj$iv2;
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"com/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt$writeServiceStats$StatItem", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "app", "", "getApp", "()I", "setApp", "(I)V", "project", "getProject", "setProject", "module", "getModule", "setModule", "intellij.platform.diagnostic.startUpPerformanceReporter"})
        public final class StatItem {
            private final String name;
            private int app;
            private int project;
            private int module;

            public StatItem(String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
            }

            public final String getName() {
                return this.name;
            }

            public final int getApp() {
                return this.app;
            }

            public final void setApp(int n) {
                this.app = n;
            }

            public final int getProject() {
                return this.project;
            }

            public final void setProject(int n) {
                this.project = n;
            }

            public final int getModule() {
                return this.module;
            }

            public final void setModule(int n) {
                this.module = n;
            }
        }
        StatItem component2 = new StatItem("component");
        StatItem service = new StatItem("service");
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        for (PluginModuleDescriptor plugin : pluginSet.getEnabledModules()) {
            service.setApp(service.getApp() + plugin.getAppContainerDescriptor().services.size());
            service.setProject(service.getProject() + plugin.getProjectContainerDescriptor().services.size());
            service.setModule(service.getModule() + plugin.getModuleContainerDescriptor().services.size());
            component2.setApp(component2.getApp() + plugin.getAppContainerDescriptor().components.size());
            component2.setProject(component2.getProject() + plugin.getProjectContainerDescriptor().components.size());
            component2.setModule(component2.getModule() + plugin.getModuleContainerDescriptor().components.size());
        }
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "stats";
        boolean $i$f$obj = false;
        String it$iv = fieldName$iv;
        boolean bl = false;
        $this$obj$iv2.writeFieldName(it$iv);
        $this$obj$iv2.writeStartObject();
        boolean bl2 = false;
        writer.writeNumberField("plugin", pluginSet.enabledPlugins.size());
        StatItem[] statItemArray = new StatItem[]{component2, service};
        for (StatItem statItem : CollectionsKt.listOf((Object[])statItemArray)) {
            JsonGenerator jsonGenerator2 = writer;
            String fieldName$iv2 = statItem.getName();
            boolean $i$f$obj2 = false;
            if (fieldName$iv2 != null) {
                String it$iv2;
                $i$a$-let-JacksonUtil$obj$1$iv = false;
                $this$obj$iv.writeFieldName(it$iv2);
            }
            $this$obj$iv.writeStartObject();
            boolean bl3 = false;
            writer.writeNumberField("app", statItem.getApp());
            writer.writeNumberField("project", statItem.getProject());
            writer.writeNumberField("module", statItem.getModule());
            $this$obj$iv.writeEndObject();
        }
        $this$obj$iv2.writeEndObject();
        $this$obj$iv2 = writer;
        fieldName$iv = "plugins";
        boolean $i$f$array = false;
        it$iv = fieldName$iv;
        boolean bl4 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl5 = false;
        for (PluginMainDescriptor plugin : pluginSet.enabledPlugins) {
            PluginAwareClassLoader classLoader;
            $this$obj$iv = plugin.getPluginClassLoader();
            PluginAwareClassLoader pluginAwareClassLoader = $this$obj$iv instanceof PluginAwareClassLoader ? (PluginAwareClassLoader)$this$obj$iv : null;
            if (pluginAwareClassLoader == null || (classLoader = pluginAwareClassLoader).getLoadedClassCount() == 0L) continue;
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv3 = null;
            boolean $i$f$obj3 = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl6 = false;
            writer.writeStringField("id", plugin.getPluginId().getIdString());
            writer.writeNumberField("classCount", classLoader.getLoadedClassCount());
            writer.writeNumberField("classLoadingEdtTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getEdtTime()));
            writer.writeNumberField("classLoadingBackgroundTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getBackgroundTime()));
            $this$obj_u24default$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    public static final /* synthetic */ String access$safeHashValue(String value) {
        return IdeIdeaFormatWriterKt.safeHashValue(value);
    }

    public static final /* synthetic */ void access$writeServiceStats(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeServiceStats(writer);
    }

    public static final /* synthetic */ void access$writeIcons(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeIcons(writer);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return IdeIdeaFormatWriterKt.getLogger();
    }
}

