/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"computeOwnTime", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "Lcom/intellij/diagnostic/ActivityImpl;", "allEvents", "", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "isInclusive", "", "otherItem", "item", "intellij.platform.diagnostic.startUpPerformanceReporter"})
@SourceDebugExtension(value={"SMAP\nserviceReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serviceReporter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/ServiceReporterKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n383#2,7:63\n13#3:70\n1807#4,3:71\n*S KotlinDebug\n*F\n+ 1 serviceReporter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/ServiceReporterKt\n*L\n20#1:63,7\n36#1:70\n45#1:71,3\n*E\n"})
public final class ServiceReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object2LongMap<ActivityImpl> computeOwnTime(@NotNull List<ActivityImpl> allEvents, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkNotNullParameter(allEvents, (String)"allEvents");
        Intrinsics.checkNotNullParameter((Object)threadNameManager, (String)"threadNameManager");
        Object2LongOpenHashMap ownDurations = new Object2LongOpenHashMap();
        ownDurations.defaultReturnValue(-1L);
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        Map threadToList = map2;
        for (ActivityImpl event : allEvents) {
            Object object;
            void $this$getOrPut$iv;
            Map map3 = threadToList;
            String key$iv = threadNameManager.getThreadName(event);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(event);
        }
        List respectedItems = new ArrayList();
        for (List list2 : threadToList.values()) {
            Iterator iterator2 = ((Iterable)list2).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                ActivityImpl otherItem;
                long totalDuration;
                int index = n++;
                ActivityImpl item = (ActivityImpl)iterator2.next();
                if (item.getCategory() == ActivityCategory.SERVICE_WAITING) continue;
                long ownDuration = totalDuration = item.getEnd() - item.getStart();
                respectedItems.clear();
                if (index > 0 && ((ActivityImpl)list2.get(index - 1)).getStart() > item.getStart()) {
                    boolean $i$f$logger = false;
                    Logger logger2 = Logger.getInstance(StartUpMeasurer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.error("prev " + ((ActivityImpl)list2.get(index - 1)).getName() + " start > " + item.getName());
                }
                int n2 = list2.size();
                for (int i2 = index + 1; i2 < n2 && (otherItem = (ActivityImpl)list2.get(i2)).getEnd() <= item.getEnd(); ++i2) {
                    boolean bl;
                    block10: {
                        if (!ServiceReporterKt.isInclusive(otherItem, item)) continue;
                        Iterable $this$any$iv = respectedItems;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ActivityImpl it = (ActivityImpl)element$iv;
                                boolean bl2 = false;
                                if (!ServiceReporterKt.isInclusive(otherItem, it)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    ownDuration -= otherItem.getEnd() - otherItem.getStart();
                    respectedItems.add(otherItem);
                }
                if (totalDuration == ownDuration) continue;
                ownDurations.put((Object)item, ownDuration);
            }
        }
        return (Object2LongMap)ownDurations;
    }

    private static final boolean isInclusive(ActivityImpl otherItem, ActivityImpl item) {
        return otherItem.getStart() >= item.getStart() && otherItem.getEnd() <= item.getEnd();
    }
}

