/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.Executor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.touchbar.ActionsLoader;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.awt.Component;
import java.util.Map;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CtxDefault {
    private static final Logger LOG = Logger.getInstance(CtxDefault.class);
    private static SimpleMessageBusConnection ourConnection = null;
    private static final String RUN_DEBUG_GROUP_TOUCHBAR = "RunnerActionsTouchbar";

    CtxDefault() {
    }

    static void initialize() {
        for (Project project2 : ProjectUtil.getOpenProjects()) {
            CtxDefault.registerTouchbarActions(project2);
        }
        ourConnection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        ourConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                CtxDefault.registerTouchbarActions(project2);
            }

            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.debug("closed project: %s", new Object[]{project2});
                JFrame frame = WindowManager.getInstance().getFrame(project2);
                if (frame == null) {
                    LOG.debug("null frame for project: %s", new Object[]{project2});
                    return;
                }
                TouchBarsManager.unregister(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDefault$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CtxDefault.fillRunDebugGroup();
    }

    static void disable() {
        if (ourConnection != null) {
            ourConnection.disconnect();
        }
        ourConnection = null;
    }

    private static void registerTouchbarActionsImpl(@NotNull Project project2) {
        if (project2 == null) {
            CtxDefault.$$$reportNull$$$0(0);
        }
        if (project2.isDisposed()) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project2);
        if (frame == null) {
            LOG.debug("null frame for project: %s", new Object[]{project2});
            return;
        }
        @Nullable Pair<Map<Long, ActionGroup>, Customizer> defaultGroup = ActionsLoader.getProjectDefaultActionGroup();
        if (defaultGroup == null) {
            LOG.debug("can't load default action group for project: %s", new Object[]{project2});
            TouchBarsManager.unregister(frame);
            return;
        }
        LOG.debug("register project-default action group %s | frame %s", new Object[]{project2, frame});
        TouchBarsManager.registerAndShow((Component)frame, (Map)defaultGroup.first, (Customizer)defaultGroup.second);
    }

    private static void registerTouchbarActions(@NotNull Project project2) {
        if (project2 == null) {
            CtxDefault.$$$reportNull$$$0(1);
        }
        StartupManager.getInstance((Project)project2).runAfterOpened(() -> {
            if (project2.isDisposed()) {
                return;
            }
            LOG.debug("register touchbar actions for project %s", new Object[]{project2});
            CtxDefault.registerTouchbarActionsImpl(project2);
        });
    }

    static void reloadAllActions() {
        for (Project project2 : ProjectUtil.getOpenProjects()) {
            CtxDefault.registerTouchbarActionsImpl(project2);
        }
    }

    private static void fillRunDebugGroup() {
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            LOG.debug("service ActionManager wasn't cerated, schedule next try after 500ms");
            SimpleTimer.getInstance().setUp(() -> CtxDefault.fillRunDebugGroup(), 500L);
            return;
        }
        AnAction runButtons = actionManager.getAction(RUN_DEBUG_GROUP_TOUCHBAR);
        if (runButtons == null) {
            LOG.debug("RunnersGroup for touchbar is unregistered");
            return;
        }
        if (!(runButtons instanceof DefaultActionGroup)) {
            LOG.debug("RunnersGroup for touchbar isn't a group");
            return;
        }
        DefaultActionGroup group2 = (DefaultActionGroup)runButtons;
        if (group2.getChildrenCount() > 0) {
            LOG.debug("RunnersGroup for touchbar is already filled, skip fill");
            return;
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (!executor.getId().equals("Run") && !executor.getId().equals("Debug")) continue;
            group2.add(actionManager.getAction(executor.getId()), actionManager);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDefault";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTouchbarActionsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTouchbarActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

