/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a)\u0010\n\u001a\u0004\u0018\u00010\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"INLINE_BUTTON_WIDTH", "", "INLINE_BUTTON_MARKER", "", "createExtraButton", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "active", "", "calcButtonIndex", "list", "Ljavax/swing/JList;", "buttonsCount", "point", "Ljava/awt/Point;", "(Ljavax/swing/JList;ILjava/awt/Point;)Ljava/lang/Integer;", "buttonWidth", "leftRightInsets", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class InlineActionsUtilKt {
    private static final int INLINE_BUTTON_WIDTH = 16;
    @NotNull
    public static final String INLINE_BUTTON_MARKER = "inlineButtonMarker";

    @NotNull
    public static final JComponent createExtraButton(@NotNull Icon icon2, boolean active) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        JLabel label2 = new JLabel(icon2);
        label2.putClientProperty(INLINE_BUTTON_MARKER, true);
        int leftRightInsets = JBUI.CurrentTheme.List.buttonLeftRightInsets();
        label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)leftRightInsets));
        SelectablePanel panel2 = SelectablePanel.Companion.wrap$default((SelectablePanel.Companion)SelectablePanel.Companion, (Component)label2, null, (int)2, null);
        Dimension size2 = panel2.getPreferredSize();
        size2.width = InlineActionsUtilKt.buttonWidth(leftRightInsets);
        panel2.setPreferredSize(size2);
        panel2.setMinimumSize(size2);
        panel2.setSelectionColor(active ? JBUI.CurrentTheme.List.buttonHoverBackground() : null);
        panel2.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
        panel2.setOpaque(false);
        return (JComponent)panel2;
    }

    @Nullable
    public static final Integer calcButtonIndex(@NotNull JList<?> list2, int buttonsCount, @NotNull Point point) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int index = list2.getSelectedIndex();
        Rectangle rectangle = list2.getCellBounds(index, index);
        if (rectangle == null) {
            return null;
        }
        Rectangle bounds = rectangle;
        JBInsets.removeFrom((Rectangle)bounds, (Insets)PopupListElementRenderer.getListCellPadding());
        int distanceToRight = bounds.x + bounds.width - point.x;
        int buttonsToRight = distanceToRight / InlineActionsUtilKt.buttonWidth$default(0, 1, null);
        if (buttonsToRight >= buttonsCount) {
            return null;
        }
        return buttonsCount - buttonsToRight - 1;
    }

    @JvmOverloads
    public static final int buttonWidth(int leftRightInsets) {
        return JBUIScale.scale((int)(16 + leftRightInsets * 2));
    }

    public static /* synthetic */ int buttonWidth$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = JBUI.CurrentTheme.List.buttonLeftRightInsets();
        }
        return InlineActionsUtilKt.buttonWidth(n);
    }

    @JvmOverloads
    public static final int buttonWidth() {
        return InlineActionsUtilKt.buttonWidth$default(0, 1, null);
    }
}

