/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.popup.WizardPopup;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class MnemonicsSearch<T> {
    private final WizardPopup myPopup;
    private final Map<String, T> myChar2ValueMap = new HashMap<String, T>();

    public MnemonicsSearch(WizardPopup popup2) {
        this.myPopup = popup2;
        if (!this.myPopup.getStep().isMnemonicsNavigationEnabled()) {
            return;
        }
        MnemonicNavigationFilter filter2 = this.myPopup.getStep().getMnemonicNavigationFilter();
        if (filter2 == null) {
            return;
        }
        for (Object each : filter2.getValues()) {
            String charText = filter2.getMnemonicString(each);
            if (charText == null) continue;
            this.myChar2ValueMap.put(Strings.toUpperCase((String)charText), each);
            this.myChar2ValueMap.put(Strings.toLowerCase((String)charText), each);
        }
    }

    public void processKeyEvent(@NotNull KeyEvent e) {
        String s;
        T toSelect;
        if (e == null) {
            MnemonicsSearch.$$$reportNull$$$0(0);
        }
        if (e.isConsumed()) {
            return;
        }
        if (e.getID() != 400) {
            return;
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)this.myPopup.getSpeedSearch().getFilter())) {
            return;
        }
        if (Character.isLetterOrDigit(e.getKeyChar()) && (toSelect = this.myChar2ValueMap.get(s = Character.toString(e.getKeyChar()))) != null) {
            this.select(toSelect);
            e.consume();
        }
    }

    protected abstract void select(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/util/MnemonicsSearch", "processKeyEvent"));
    }
}

