/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0014\b\u0004\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0086\b\u00f8\u0001\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002\u001a5\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2#\b\u0004\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\u0003H\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0005*\u00020\u0004\u001a0\u0010\u0017\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0007\u001a.\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u001a6\u0010\"\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010#\u001a\u00020\u001cH\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001cH\u0002\u001a\u0010\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010/\u001a\u00020+\u001a)\u00106\u001a\u0002H7\"\u0004\b\u0000\u00107*\u0002082\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H709H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:\u001a\"\u0010;\u001a\u00020<2\u0006\u0010*\u001a\u00020%2\b\b\u0002\u0010=\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020<\u001a \u0010?\u001a\u00020<*\u00020+2\b\b\u0002\u0010=\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020<H\u0007\u001a\u0012\u0010@\u001a\u00020<2\b\b\u0001\u0010A\u001a\u00020BH\u0002\u001a(\u0010D\u001a\u00020<2\n\b\u0001\u0010E\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010=\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020<H\u0007\u001a\n\u0010F\u001a\u00020<*\u00020+\u001a\n\u0010G\u001a\u00020<*\u00020+\u001a\n\u0010H\u001a\u00020%*\u000208\"\u0015\u0010'\u001a\u00020%*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0017\u0010*\u001a\u0004\u0018\u00010%*\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0017\u00100\u001a\u0004\u0018\u00010%*\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010-\"\u0017\u00102\u001a\u0004\u0018\u00010%*\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010-\"\u0017\u00104\u001a\u0004\u0018\u00010%*\u00020+8G\u00a2\u0006\u0006\u001a\u0004\b5\u0010-\"\u001a\u0010*\u001a\u0004\u0018\u00010%*\u00020B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010C\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006I"}, d2={"handler", "Lio/netty/bootstrap/Bootstrap;", "task", "Lkotlin/Function1;", "Lio/netty/channel/Channel;", "", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "serverSocketChannelClass", "Ljava/lang/Class;", "Lio/netty/channel/socket/ServerSocketChannel;", "eventLoopGroup", "addChannelListener", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/ParameterName;", "name", "future", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "closeAndShutdownEventLoop", "connectRetrying", "Lcom/intellij/util/io/ConnectToChannelResult;", "remoteAddress", "Ljava/net/InetSocketAddress;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "doConnect", "bootstrap", "connectNio", "_attemptCount", "sleep", "", "time", "uriScheme", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "host", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "getHostName", "httpRequest", "origin", "getOrigin", "referrer", "getReferrer", "userAgent", "getUserAgent", "releaseIfError", "T", "Lio/netty/buffer/ByteBuf;", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isLocalOrigin", "isTrustedChromeExtension", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)Ljava/lang/String;", "parseAndCheckIsLocalHost", "uri", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "readUtf8", "intellij.platform.ide.util.netty"})
@SourceDebugExtension(value={"SMAP\nnetty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 netty.kt\ncom/intellij/util/io/NettyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(@NotNull Bootstrap $this$handler, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkNotNullParameter((Object)$this$handler, (String)"<this>");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$handler = false;
        $this$handler.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1<Channel, Unit> $task;
            {
                this.$task = $task;
            }

            protected void initChannel(Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
        });
        return $this$handler;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group2).channel(NettyKt.serverSocketChannelClass(group2));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        Intrinsics.checkNotNull((Object)bootstrap);
        return bootstrap;
    }

    private static final Class<? extends ServerSocketChannel> serverSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Class<NioServerSocketChannel> clazz;
        EventLoopGroup eventLoopGroup2 = eventLoopGroup;
        if (eventLoopGroup2 instanceof NioEventLoopGroup) {
            clazz = NioServerSocketChannel.class;
        } else if (eventLoopGroup2 instanceof OioEventLoopGroup) {
            clazz = OioServerSocketChannel.class;
        } else {
            throw new Exception("Unknown event loop group type: " + eventLoopGroup.getClass().getName());
        }
        return clazz;
    }

    public static final void addChannelListener(@NotNull ChannelFuture $this$addChannelListener, @NotNull Function1<? super ChannelFuture, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$addChannelListener, (String)"<this>");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener.addListener(new GenericFutureListener(listener2){
            final /* synthetic */ Function1<ChannelFuture, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                this.$listener.invoke((Object)it);
            }
        });
    }

    public static final void shutdownIfOio(@NotNull EventLoop $this$shutdownIfOio) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$shutdownIfOio, (String)"<this>");
            EventLoopGroup eventLoopGroup = $this$shutdownIfOio.parent();
            OioEventLoopGroup oioEventLoopGroup = eventLoopGroup instanceof OioEventLoopGroup ? (OioEventLoopGroup)eventLoopGroup : null;
            if (oioEventLoopGroup == null) break block0;
            oioEventLoopGroup.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(@NotNull Channel $this$closeAndShutdownEventLoop) {
        Intrinsics.checkNotNullParameter((Object)$this$closeAndShutdownEventLoop, (String)"<this>");
        EventLoop eventLoop = $this$closeAndShutdownEventLoop.eventLoop();
        try {
            $this$closeAndShutdownEventLoop.close().awaitUninterruptibly();
        }
        finally {
            Intrinsics.checkNotNull((Object)eventLoop);
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @RequiresBackgroundThread
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkNotNullParameter((Object)$this$connectRetrying, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                Condition condition2 = Conditions.alwaysFalse();
                condition = condition2;
                Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"alwaysFalse(...)");
            }
            return NettyKt.doConnect($this$connectRetrying, remoteAddress, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            return new ConnectToChannelResult(e);
        }
    }

    public static /* synthetic */ ConnectToChannelResult connectRetrying$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, int n, Condition condition, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        if ((n2 & 4) != 0) {
            condition = null;
        }
        return NettyKt.connectRetrying(bootstrap, inetSocketAddress, n, (Condition<Void>)condition);
    }

    /*
     * Unable to fully structure code
     */
    private static final ConnectToChannelResult doConnect(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition) {
        attemptCount = 0;
        if (!(bootstrap.config().group() instanceof OioEventLoopGroup)) {
            return NettyKt.connectNio(bootstrap, remoteAddress, maxAttemptCount, stopCondition, attemptCount);
        }
        bootstrap.validate();
        while (true) {
            try {
                channel = new OioSocketChannel(new Socket(remoteAddress.getAddress(), remoteAddress.getPort()));
                BootstrapUtil.INSTANCE.initAndRegister((Channel)channel, bootstrap).sync();
                return new ConnectToChannelResult((Channel)channel);
            }
            catch (IOException e) {
                if (stopCondition.value(null)) {
                    return new ConnectToChannelResult(null, 1, null);
                }
                if (maxAttemptCount == -1) {
                    var7_6 = NettyKt.sleep(300);
                    if (var7_6 != null) {
                        it = var7_6;
                        $i$a$-let-NettyKt$doConnect$1 = false;
                        return new ConnectToChannelResult(it);
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount < maxAttemptCount) {
                    var7_6 = NettyKt.sleep(attemptCount * 100);
                    if (var7_6 != null) ** break;
                    continue;
                    it = var7_6;
                    $i$a$-let-NettyKt$doConnect$2 = false;
                    return new ConnectToChannelResult(it);
                }
                return new ConnectToChannelResult(e);
            }
            break;
        }
    }

    private static final ConnectToChannelResult connectNio(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition, int _attemptCount) {
        ChannelFuture future;
        block7: {
            String string;
            int attemptCount = _attemptCount;
            Logger.getInstance((String)"com.intellij.util.io.netty").debug("connectNio: " + Thread.currentThread() + " #" + attemptCount + ", max:#" + maxAttemptCount + " to " + remoteAddress);
            while (true) {
                Logger.getInstance((String)"com.intellij.util.io.netty").debug("Connection attempt #" + attemptCount + " to " + remoteAddress);
                future = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly();
                if (future.isSuccess()) {
                    if (!future.channel().isOpen()) {
                        Logger.getInstance((String)"com.intellij.util.io.netty").debug("connectNio: !future.channel().isOpen");
                    }
                    return new ConnectToChannelResult(future.channel());
                }
                if (stopCondition.value(null)) {
                    return new ConnectToChannelResult(null, 1, null);
                }
                if (maxAttemptCount == -1) {
                    string = NettyKt.sleep(300);
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        return new ConnectToChannelResult(it);
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount >= maxAttemptCount) break block7;
                string = NettyKt.sleep(attemptCount * 100);
                if (string != null) break;
            }
            String it = string;
            boolean bl = false;
            return new ConnectToChannelResult(it);
        }
        Throwable cause = future.cause();
        if (cause == null) {
            String string = IdeUtilIoBundle.message((String)"error.message.cannot.connect.unknown.error", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ConnectToChannelResult(string);
        }
        return new ConnectToChannelResult(cause);
    }

    private static final String sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignored) {
            return IdeUtilIoBundle.message((String)"error.message.interrupted", (Object[])new Object[0]);
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static final String getUriScheme(@NotNull Channel $this$uriScheme) {
        Intrinsics.checkNotNullParameter((Object)$this$uriScheme, (String)"<this>");
        return $this$uriScheme.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(@NotNull HttpRequest $this$host) {
        Intrinsics.checkNotNullParameter((Object)$this$host, (String)"<this>");
        return $this$host.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getHostName(@NotNull HttpRequest httpRequest) {
        String string;
        String string2;
        block10: {
            block9: {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                string2 = httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
                if (string2 == null) break block9;
                CharSequence charSequence2 = string2;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                if ((string2 = (String)charSequence) != null) break block10;
            }
            return null;
        }
        String hostAndPort = string2;
        int portIndex = StringsKt.lastIndexOf$default((CharSequence)hostAndPort, (char)':', (int)0, (boolean)false, (int)6, null);
        if (portIndex > 0) {
            CharSequence charSequence;
            String string3 = hostAndPort.substring(0, portIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            CharSequence charSequence3 = string3;
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence3;
            }
            string = (String)charSequence;
        } else {
            string = hostAndPort;
        }
        return string;
    }

    @Nullable
    public static final String getOrigin(@NotNull HttpRequest $this$origin) {
        Intrinsics.checkNotNullParameter((Object)$this$origin, (String)"<this>");
        return $this$origin.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(@NotNull HttpRequest $this$referrer) {
        Intrinsics.checkNotNullParameter((Object)$this$referrer, (String)"<this>");
        return $this$referrer.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @NlsSafe
    @Nullable
    public static final String getUserAgent(@NotNull HttpRequest $this$userAgent) {
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"<this>");
        return $this$userAgent.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(@NotNull ByteBuf $this$releaseIfError, @NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter((Object)$this$releaseIfError, (String)"<this>");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$releaseIfError = false;
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $this$releaseIfError.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw e;
            }
        }
    }

    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            Intrinsics.checkNotNull((Object)address);
            if (!NettyKt.isLocalHost$isLocal(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                InetAddress it = HostsFileEntriesResolver.DEFAULT.address(host, ResolvedAddressTypes.IPV4_PREFERRED);
                boolean bl = false;
                return it != null && NettyKt.isLocalHost$isLocal(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* synthetic */ boolean isLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalOrigin, (String)"<this>");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($this$isLocalOrigin), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($this$isLocalOrigin), onlyAnyOrLoopback, hostsOnly);
    }

    public static /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTrustedChromeExtension(@NlsSafe Url url) {
        if (!Intrinsics.areEqual((Object)url.getScheme(), (Object)"chrome-extension")) return false;
        if (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji")) return true;
        if (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"offnedcbhjldheanlbojaefbfbllddna")) return true;
        String string = System.getProperty("idea.trusted.chrome.extension.id");
        if (string == null) return false;
        boolean bl = string.equals(url.getAuthority());
        if (!bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getHost(Url $this$host) {
        String string;
        String string2 = $this$host.getAuthority();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            int portIndex = StringsKt.indexOf$default((CharSequence)it, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex > 0) {
                String string3 = it.substring(0, portIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                void var1_1;
                string = var1_1;
            }
        } else {
            string = null;
        }
        return string;
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null || Intrinsics.areEqual((Object)uri, (Object)"about:blank")) {
            return true;
        }
        try {
            Url url = Urls.parse((String)uri, (boolean)false);
            if (url == null) {
                return false;
            }
            Url parsedUri = url;
            String host = NettyKt.getHost(parsedUri);
            return host != null && (NettyKt.isTrustedChromeExtension(parsedUri) || NettyKt.isLocalHost(host, onlyAnyOrLoopback, hostsOnly));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string, bl, bl2);
    }

    public static final boolean isRegularBrowser(@NotNull HttpRequest $this$isRegularBrowser) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegularBrowser, (String)"<this>");
        String string = NettyKt.getUserAgent($this$isRegularBrowser);
        return string != null ? StringsKt.startsWith$default((String)string, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(@NotNull HttpRequest $this$isWriteFromBrowserWithoutOrigin) {
        Intrinsics.checkNotNullParameter((Object)$this$isWriteFromBrowserWithoutOrigin, (String)"<this>");
        HttpMethod method = $this$isWriteFromBrowserWithoutOrigin.method();
        CharSequence charSequence = NettyKt.getOrigin($this$isWriteFromBrowserWithoutOrigin);
        return (charSequence == null || charSequence.length() == 0) && NettyKt.isRegularBrowser($this$isWriteFromBrowserWithoutOrigin) && (Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.DELETE));
    }

    @NotNull
    public static final String readUtf8(@NotNull ByteBuf $this$readUtf8) {
        Intrinsics.checkNotNullParameter((Object)$this$readUtf8, (String)"<this>");
        String string = $this$readUtf8.toString(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    @RequiresBackgroundThread
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount) {
        Intrinsics.checkNotNullParameter((Object)$this$connectRetrying, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        return NettyKt.connectRetrying$default($this$connectRetrying, remoteAddress, maxAttemptCount, null, 4, null);
    }

    @JvmOverloads
    @RequiresBackgroundThread
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$connectRetrying, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        return NettyKt.connectRetrying$default($this$connectRetrying, remoteAddress, 0, null, 6, null);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin, boolean onlyAnyOrLoopback) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalOrigin, (String)"<this>");
        return NettyKt.isLocalOrigin$default($this$isLocalOrigin, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalOrigin, (String)"<this>");
        return NettyKt.isLocalOrigin$default($this$isLocalOrigin, false, false, 3, null);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, false, false, 6, null);
    }

    private static final boolean isLocalHost$isLocal(InetAddress $this$isLocalHost_u24isLocal) {
        return $this$isLocalHost_u24isLocal.isAnyLocalAddress() || $this$isLocalHost_u24isLocal.isLoopbackAddress() || NetworkInterface.getByInetAddress($this$isLocalHost_u24isLocal) != null;
    }
}

