/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.ultimate.AbstractJavaProfilerConfigurationState;
import com.intellij.profiler.ultimate.ProfilerRunnerSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/DefaultJavaProfilerRunner;", "Lcom/intellij/execution/impl/DefaultJavaProgramRunner;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "Lcom/intellij/profiler/ultimate/ProfilerRunnerSettings;", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "Companion", "intellij.profiler.ultimate"})
public final class DefaultJavaProfilerRunner
extends DefaultJavaProgramRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNNER_ID = "Profile";

    @NotNull
    public String getRunnerId() {
        return RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (profile instanceof RunConfigurationWithSuppressedDefaultRunAction) {
            return false;
        }
        DefaultProfilerExecutorGroup defaultProfilerExecutorGroup = DefaultProfilerExecutorGroup.Companion.getInstance();
        DefaultProfilerExecutorGroup.ProfilerExecutorSettings settings = defaultProfilerExecutorGroup != null ? (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)defaultProfilerExecutorGroup.getRegisteredSettings(executorId) : null;
        DefaultProfilerExecutorGroup.ProfilerExecutorSettings profilerExecutorSettings = settings;
        if (profilerExecutorSettings == null || (profilerExecutorSettings = profilerExecutorSettings.getState()) == null) {
            return false;
        }
        DefaultProfilerExecutorGroup.ProfilerExecutorSettings registeredSettingsState = profilerExecutorSettings;
        return registeredSettingsState instanceof AbstractJavaProfilerConfigurationState && settings.canRun(profile);
    }

    @NotNull
    public ProfilerRunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        return new ProfilerRunnerSettings();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ultimate/DefaultJavaProfilerRunner$Companion;", "", "<init>", "()V", "RUNNER_ID", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

