/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefsOfSingleRoot;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Set;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/log/data/CompressedRefs;", "Lcom/intellij/vcs/log/VcsLogRefsOfSingleRoot;", "refs", "", "Lcom/intellij/vcs/log/VcsRef;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "<init>", "(Ljava/util/Set;Lcom/intellij/vcs/log/data/VcsLogStorage;)V", "tagsMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "tags", "Lkotlin/sequences/Sequence;", "getTags", "()Lkotlin/sequences/Sequence;", "branchesMapping", "", "branches", "getBranches", "contains", "", "index", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "refsToCommit", "Lcom/intellij/util/SmartList;", "getRefsIndexes", "", "forEachBranchIndex", "", "consumer", "Ljava/util/function/IntConsumer;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nCompressedRefs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressedRefs.kt\ncom/intellij/vcs/log/data/CompressedRefs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n1#2:84\n1915#3,2:85\n13#4:87\n*S KotlinDebug\n*F\n+ 1 CompressedRefs.kt\ncom/intellij/vcs/log/data/CompressedRefs\n*L\n56#1:85,2\n80#1:87\n*E\n"})
public final class CompressedRefs
implements VcsLogRefsOfSingleRoot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Int2ObjectMap<IntArrayList> tagsMapping;
    @NotNull
    private final Sequence<VcsRef> tags;
    @NotNull
    private final Int2ObjectMap<Collection<VcsRef>> branchesMapping;
    @NotNull
    private final Sequence<VcsRef> branches;
    @NotNull
    private static final Logger LOG;

    public CompressedRefs(@NotNull Set<? extends VcsRef> refs, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.tagsMapping = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        Collection collection = this.tagsMapping.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        this.tags = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> CompressedRefs.tags$lambda$0(this, arg_0));
        this.branchesMapping = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        Collection collection2 = this.branchesMapping.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"<get-values>(...)");
        this.branches = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection2), CompressedRefs::branches$lambda$0);
        VirtualFile root = null;
        for (VcsRef vcsRef : refs) {
            boolean bl;
            boolean bl2 = bl = root == null || Intrinsics.areEqual(root, (Object)vcsRef.getRoot());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CompressedRefs$232 = false;
                String $i$a$-assert-CompressedRefs$232 = "All references are supposed to be from the single root";
                throw new AssertionError((Object)$i$a$-assert-CompressedRefs$232);
            }
            root = vcsRef.getRoot();
            Hash hash = vcsRef.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = vcsRef.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            int index = this.storage.getCommitIndex(hash, virtualFile);
            if (vcsRef.getType().isBranch()) {
                ((Collection)this.branchesMapping.computeIfAbsent(index, CompressedRefs::_init_$lambda$1)).add(vcsRef);
                continue;
            }
            int refIndex = this.storage.getRefIndex(vcsRef);
            if (refIndex == -1) continue;
            ((IntArrayList)this.tagsMapping.computeIfAbsent(index, CompressedRefs::_init_$lambda$2)).add(refIndex);
        }
        ObjectIterator objectIterator = ((ObjectCollection)this.tagsMapping.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            IntArrayList intArrayList = (IntArrayList)objectIterator2.next();
            intArrayList.trim();
        }
    }

    @NotNull
    public Sequence<VcsRef> getTags() {
        return this.tags;
    }

    @NotNull
    public Sequence<VcsRef> getBranches() {
        return this.branches;
    }

    public boolean contains(int index) {
        return this.branchesMapping.containsKey(index) || this.tagsMapping.containsKey(index);
    }

    @NotNull
    public SmartList<VcsRef> refsToCommit(int index) {
        SmartList result;
        block3: {
            result = new SmartList();
            Collection collection = (Collection)this.branchesMapping.get(index);
            if (collection != null) {
                Collection it = collection;
                boolean bl = false;
                result.addAll(it);
            }
            IntArrayList intArrayList = (IntArrayList)this.tagsMapping.get(index);
            if (intArrayList == null) break block3;
            Iterable $this$forEach$iv = (Iterable)intArrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Integer tag = (Integer)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tag);
                VcsRef ref = this.storage.getVcsRef(tag);
                if (ref != null) {
                    result.add((Object)ref);
                    continue;
                }
                LOG.error("Could not find a tag by id " + tag + " at commit " + this.storage.getCommitId(index));
            }
        }
        return result;
    }

    @NotNull
    public Collection<Integer> getRefsIndexes() {
        IntOpenHashSet result = new IntOpenHashSet(((IntSet)this.branchesMapping.keySet()).size() + ((IntSet)this.tagsMapping.keySet()).size());
        result.addAll((IntCollection)this.branchesMapping.keySet());
        result.addAll((IntCollection)this.tagsMapping.keySet());
        return (Collection)result;
    }

    public void forEachBranchIndex(@NotNull IntConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        ((IntSet)this.branchesMapping.keySet()).forEach(consumer);
    }

    private static final VcsRef tags$lambda$0$0(CompressedRefs this$0, Integer it) {
        VcsLogStorage vcsLogStorage = this$0.storage;
        Intrinsics.checkNotNull((Object)it);
        return vcsLogStorage.getVcsRef(it);
    }

    private static final Sequence tags$lambda$0(CompressedRefs this$0, IntArrayList tagsCollection) {
        Intrinsics.checkNotNullParameter((Object)tagsCollection, (String)"tagsCollection");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)tagsCollection)), arg_0 -> CompressedRefs.tags$lambda$0$0(this$0, arg_0));
    }

    private static final Sequence branches$lambda$0(Collection it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.asSequence((Iterable)it);
    }

    private static final Collection _init_$lambda$1(int it) {
        return (Collection)new SmartList();
    }

    private static final IntArrayList _init_$lambda$2(int it) {
        return new IntArrayList();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompressedRefs.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/data/CompressedRefs$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

