/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.compiler.progress.BuildIssueContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.SetupModuleSdkQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.UpdateSourceLevelQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u0006J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix;", "Lcom/intellij/compiler/progress/BuildIssueContributor;", "<init>", "()V", "matchersList", "", "", "createBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "project", "Lcom/intellij/openapi/project/Project;", "moduleNames", "", "title", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigatable", "Lcom/intellij/pom/Navigatable;", "getLanguageLevelFromError", "Lcom/intellij/pom/java/LanguageLevel;", "getBuildIssueSourceVersionGreat", "sourceLanguageLevel", "moduleProjectLanguageLevel", "errorMessage", "moduleRootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getBuildIssueSourceVersionLess", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nJpsLanguageLevelQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLanguageLevelQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n777#3:137\n873#3:138\n1786#3,3:139\n874#3:142\n1586#3:143\n1661#3,3:144\n*S KotlinDebug\n*F\n+ 1 JpsLanguageLevelQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix\n*L\n62#1:137\n62#1:138\n62#1:139,3\n62#1:142\n63#1:143\n63#1:144,3\n*E\n"})
public final class JpsLanguageLevelQuickFix
implements BuildIssueContributor {
    @NotNull
    private final List<List<String>> matchersList;

    public JpsLanguageLevelQuickFix() {
        Object[] objectArray = new List[4];
        Object[] objectArray2 = new String[]{"source release", "requires target release"};
        objectArray[0] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new String[]{"release version", "not supported"};
        objectArray[1] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[2] = CollectionsKt.listOf((Object)"invalid source release:");
        objectArray[3] = CollectionsKt.listOf((Object)"invalid target release");
        this.matchersList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public BuildIssue createBuildIssue(@NotNull Project project, @NotNull Collection<String> moduleNames, @NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @Nullable VirtualFile virtualFile, @Nullable Navigatable navigatable) {
        Sdk sdk;
        ModuleRootManager moduleRootManager;
        MavenProject mavenProject;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                if (project.isDisposed()) {
                    return null;
                }
                MavenProjectsManager mavenManager = MavenProjectsManager.getInstance(project);
                if (!mavenManager.isMavenizedProject()) {
                    return null;
                }
                if (moduleNames.size() != 1) {
                    return null;
                }
                String moduleName = (String)CollectionsKt.first((Iterable)moduleNames);
                Module module = ModuleManager.Companion.getInstance(project).findModuleByName(moduleName);
                if (module == null) {
                    return null;
                }
                Module module2 = module;
                MavenProject mavenProject2 = mavenManager.findProject(module2);
                if (mavenProject2 == null) {
                    return null;
                }
                mavenProject = mavenProject2;
                ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module2);
                if (moduleRootManager2 == null) {
                    return null;
                }
                moduleRootManager = moduleRootManager2;
                Sdk moduleJdk = moduleRootManager.getSdk();
                sdk = moduleJdk;
                if (sdk == null) break block11;
                Sdk it = sdk;
                boolean bl = false;
                LanguageLevel languageLevel = LanguageLevel.Companion.parse(it.getVersionString());
                sdk = languageLevel;
                if (languageLevel != null) break block12;
            }
            return null;
        }
        Sdk moduleProjectLanguageLevel = sdk;
        LanguageLevel languageLevel = this.getLanguageLevelFromError(message);
        if (languageLevel == null) {
            return null;
        }
        LanguageLevel sourceLanguageLevel = languageLevel;
        if (sourceLanguageLevel.isLessThan((LanguageLevel)moduleProjectLanguageLevel)) {
            return this.getBuildIssueSourceVersionLess(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, mavenProject, moduleRootManager);
        }
        return this.getBuildIssueSourceVersionGreat(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, moduleRootManager);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LanguageLevel getLanguageLevelFromError(@NotNull String message) {
        LanguageLevel languageLevel;
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        List it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String[] stringArray = this.matchersList;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                it = (List)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = it;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (StringsKt.contains$default((CharSequence)message, (CharSequence)it2, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = message.substring(StringsKt.indexOf$default((CharSequence)message, (String)((String)CollectionsKt.first((List)it)), (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (string == null) {
            return null;
        }
        String targetMessage = string;
        stringArray = targetMessage;
        Regex $i$f$map22 = new Regex("[^.0123456789]");
        $this$mapTo$iv$iv = " ";
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)$i$f$map22.replace((CharSequence)stringArray, $this$mapTo$iv$iv))).toString(), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null));
        if (string2 != null) {
            String it3 = string2;
            boolean bl = false;
            languageLevel = LanguageLevel.Companion.parse(it3);
        } else {
            languageLevel = null;
        }
        return languageLevel;
    }

    private final BuildIssue getBuildIssueSourceVersionGreat(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, ModuleRootManager moduleRootManager) {
        String string = moduleRootManager.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        List quickFixes = CollectionsKt.listOf((Object)setupModuleSdkQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        Object[] objectArray = new Object[]{moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.great", objectArray));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            private final String title;
            private final String description;
            private final List<SetupModuleSdkQuickFix> quickFixes;
            {
                this.title = $errorMessage;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<SetupModuleSdkQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }

    private final BuildIssue getBuildIssueSourceVersionLess(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, MavenProject mavenProject, ModuleRootManager moduleRootManager) {
        String string = moduleRootManager.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        Object[] objectArray = new Object[]{moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.header", objectArray));
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        quickFixes.add(setupModuleSdkQuickFix);
        issueDescription.append("\n");
        Object[] objectArray2 = new Object[]{sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part1", objectArray2));
        UpdateSourceLevelQuickFix updateSourceLevelQuickFix = new UpdateSourceLevelQuickFix(mavenProject);
        quickFixes.add(updateSourceLevelQuickFix);
        issueDescription.append("\n");
        Object[] objectArray3 = new Object[]{moduleProjectLanguageLevel.toJavaVersion(), updateSourceLevelQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part2", objectArray3));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            private final String title;
            private final String description;
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $errorMessage;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }
}

