/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.AdditionalMavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettingsForm;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenImportingConfigurable
implements SearchableConfigurable {
    public static final String SETTINGS_ID = "reference.settings.project.maven.importing";
    private final MavenImportingSettings myImportingSettings;
    private final MavenImportingSettingsForm mySettingsForm;
    private final List<UnnamedConfigurable> myAdditionalConfigurables;
    @NotNull
    private final Disposable myDisposable;
    private final Project myProject;

    public MavenImportingConfigurable(@NotNull Project project) {
        if (project == null) {
            MavenImportingConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        this.myImportingSettings = mavenProjectsManager.getImportingSettings();
        this.myDisposable = Disposer.newDisposable((Disposable)mavenProjectsManager, (String)"Maven importing configurable disposable");
        this.myAdditionalConfigurables = new ArrayList<UnnamedConfigurable>();
        for (AdditionalMavenImportingSettings additionalSettings : (AdditionalMavenImportingSettings[])AdditionalMavenImportingSettings.EP_NAME.getExtensions()) {
            this.myAdditionalConfigurables.add(additionalSettings.createConfigurable(project));
        }
        this.mySettingsForm = new MavenImportingSettingsForm(this.myProject, this.myDisposable);
    }

    public JComponent createComponent() {
        JPanel panel = this.mySettingsForm.getAdditionalSettingsPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(5));
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            panel.add(Box.createVerticalStrut(3));
            panel.add(additionalConfigurable.createComponent());
        }
        return this.mySettingsForm.createComponent();
    }

    public void disposeUIResources() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.disposeUIResources();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public boolean isModified() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            if (!additionalConfigurable.isModified()) continue;
            return true;
        }
        return this.mySettingsForm.isModified(this.myImportingSettings);
    }

    public void apply() throws ConfigurationException {
        this.mySettingsForm.getData(this.myImportingSettings);
        ExternalProjectsManagerImpl.getInstance((Project)this.myProject).setStoreExternally(true);
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.apply();
        }
    }

    public void reset() {
        this.mySettingsForm.setData(this.myImportingSettings, this.myProject);
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.reset();
        }
    }

    @Nls
    public String getDisplayName() {
        return MavenProjectBundle.message("maven.tab.importing", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        return SETTINGS_ID;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MavenImportingConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenImportingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

