/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.FilePosition;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenWrapperMapping;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.NioFiles;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u001a\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport;", "", "<init>", "()V", "downloadAndInstallMaven", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "extractMavenHomeDirectory", "Ljava/nio/file/Path;", "zipFile", "makeMavenBinRunnable", "", "mavenHome", "unzip", "zip", "deleteRecursively", "path", "getZipFile", "distributionUrl", "getDistName", "distUrl", "getMd5Hash", "string", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenWrapperSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1#2:289\n296#3,2:290\n777#3:292\n873#3,2:293\n*S KotlinDebug\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport\n*L\n102#1:290,2\n114#1:292\n114#1:293,2\n*E\n"})
public final class MavenWrapperSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";

    @NotNull
    public final MavenDistribution downloadAndInstallMaven(@NotNull String urlString, @Nullable ProgressIndicator indicator, @NotNull Project project) throws IOException {
        Path existingMavenHome;
        Object v6;
        Path zipFile;
        block9: {
            Object[] partFile;
            MavenDistribution current;
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            MavenDistribution mavenDistribution = current = Companion.getCurrentDistribution(project, urlString);
            if (mavenDistribution != null) {
                return mavenDistribution;
            }
            zipFile = this.getZipFile(urlString, project);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(zipFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                block8: {
                    partFile = zipFile.getParent().resolve(PathsKt.getName((Path)zipFile) + ".part-" + System.currentTimeMillis());
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator != null) {
                        ProgressIndicator progressIndicator2;
                        ProgressIndicator $this$downloadAndInstallMaven_u24lambda_u240 = progressIndicator2 = progressIndicator;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{urlString};
                        $this$downloadAndInstallMaven_u24lambda_u240.setText(SyncBundle.message("maven.sync.wrapper.downloading.from", objectArray));
                    }
                    try {
                        HttpRequests.request((String)urlString).tuner(arg_0 -> MavenWrapperSupport.downloadAndInstallMaven$lambda$1(indicator, arg_0)).forceHttps(false).useProxy(true).connectTimeout(30000).readTimeout(30000).saveToFile((Path)partFile, indicator);
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ControlFlowException)) break block8;
                        throw new RuntimeException(SyncBundle.message("maven.sync.wrapper.downloading.canceled", new Object[0]));
                    }
                }
                NioFiles.rename((Path)partFile, zipFile);
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists(zipFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                partFile = new Object[]{urlString};
                throw new RuntimeException(SyncBundle.message("cannot.download.zip.from", partFile));
            }
            Path path = zipFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                v6 = element$iv;
                break block9;
            }
            v6 = null;
        }
        Path path = v6;
        Path path2 = existingMavenHome = path != null ? path.toRealPath(new LinkOption[0]) : null;
        if (existingMavenHome != null) {
            return new LocalMavenDistribution(existingMavenHome, urlString);
        }
        this.unzip(zipFile, indicator);
        Path home = this.extractMavenHomeDirectory(zipFile);
        Companion.setDistributionPath(project, urlString, home);
        return new LocalMavenDistribution(home, urlString);
    }

    /*
     * WARNING - void declaration
     */
    private final Path extractMavenHomeDirectory(Path zipFile) {
        void $this$filterTo$iv$iv;
        Path path = zipFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Object[] $this$filter$iv = (Object[])PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dirs = (List)destination$iv$iv;
        if (dirs.size() != 1) {
            MavenLog.LOG.warn("Expected exactly 1 top level dir in Maven distribution, found: " + dirs);
            $this$filter$iv = new Object[]{zipFile.toAbsolutePath()};
            throw new IllegalStateException(SyncBundle.message("zip.is.not.correct", $this$filter$iv));
        }
        Path mavenHome = (Path)dirs.get(0);
        if (EelPlatformKt.isPosix((EelOsFamily)EelProviderUtil.getEelDescriptor((Path)mavenHome).getOsFamily())) {
            this.makeMavenBinRunnable(mavenHome);
        }
        Path path2 = mavenHome.toRealPath(new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toRealPath(...)");
        return path2;
    }

    private final void makeMavenBinRunnable(Path mavenHome) {
        Path mvnExe = mavenHome.resolve("bin/mvn").toRealPath(new LinkOption[0]);
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
        Files.setPosixFilePermissions(mvnExe, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unzip(Path zip, ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2;
            ProgressIndicator $this$unzip_u24lambda_u240 = progressIndicator2 = progressIndicator;
            boolean bl = false;
            $this$unzip_u24lambda_u240.setText(SyncBundle.message("maven.sync.wrapper.unpacking", new Object[0]));
        }
        Path unpackDir = zip.getParent();
        Path destinationCanonicalPath = unpackDir.toAbsolutePath().normalize();
        boolean errorUnpacking = true;
        try {
            Closeable closeable = (Closeable)new JBZipFile(zip);
            Throwable throwable = null;
            try {
                JBZipFile zipFile = (JBZipFile)closeable;
                boolean bl3 = false;
                for (JBZipEntry entry : zipFile.getEntries()) {
                    Long l;
                    Comparable comparable;
                    Path entryPath = unpackDir.resolve(entry.getName());
                    Path canonicalPath = entryPath.toAbsolutePath().normalize();
                    if (!canonicalPath.startsWith(destinationCanonicalPath)) {
                        Files.deleteIfExists(zip);
                        throw new RuntimeException("Directory traversal attack detected; zip file is malicious and has been deleted.");
                    }
                    if (entry.isDirectory()) {
                        comparable = Files.createDirectories(entryPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Closeable closeable2 = entry.getInputStream();
                    Throwable throwable2 = null;
                    try {
                        InputStream input = (InputStream)closeable2;
                        boolean bl2 = false;
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        l = Files.copy(input, entryPath, copyOptionArray);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    comparable = l;
                }
                zipFile = Unit.INSTANCE;
            }
            catch (Throwable bl3) {
                throwable = bl3;
                throw bl3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            errorUnpacking = false;
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                Closeable $this$unzip_u24lambda_u242 = closeable = progressIndicator3;
                boolean bl = false;
                Object[] bl3 = new Object[]{destinationCanonicalPath};
                $this$unzip_u24lambda_u242.setText(SyncBundle.message("maven.sync.wrapper.unpacked.into", bl3));
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (errorUnpacking) {
                    Object object;
                    ProgressIndicator progressIndicator4 = indicator;
                    if (progressIndicator4 != null) {
                        ProgressIndicator $this$unzip_u24lambda_u243 = object = progressIndicator4;
                        boolean bl = false;
                        $this$unzip_u24lambda_u243.setText(SyncBundle.message("maven.sync.wrapper.failure", new Object[0]));
                    }
                    object = Files.list(unpackDir);
                    Throwable throwable4 = null;
                    try {
                        Stream stream = (Stream)object;
                        boolean bl = false;
                        stream.filter(arg_0 -> MavenWrapperSupport.unzip$lambda$4$1(arg_0 -> MavenWrapperSupport.unzip$lambda$4$0(zip, arg_0), arg_0)).forEach(arg_0 -> MavenWrapperSupport.unzip$lambda$4$3(arg_0 -> MavenWrapperSupport.unzip$lambda$4$2(this, arg_0), arg_0));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable4);
                    }
                }
                throw throwable;
            }
        }
    }

    private final void deleteRecursively(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> MavenWrapperSupport.deleteRecursively$lambda$1(MavenWrapperSupport::deleteRecursively$lambda$0, arg_0));
        } else {
            Files.deleteIfExists(path);
        }
    }

    private final Path getZipFile(String distributionUrl, Project project) {
        String baseName = this.getDistName(distributionUrl);
        String string = FileUtil.getNameWithoutExtension((String)baseName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String distName = string;
        String md5Hash = this.getMd5Hash(distributionUrl);
        Path m2dir = MavenUtil.INSTANCE.resolveM2Dir(project);
        Path distsDir = m2dir.resolve("wrapper/dists");
        Path path = distsDir.resolve(distName).resolve(md5Hash).resolve(baseName).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    private final String getDistName(String distUrl) {
        String string;
        int p = StringsKt.lastIndexOf$default((CharSequence)distUrl, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (p < 0) {
            string = distUrl;
        } else {
            String string2 = distUrl.substring(p + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    private final String getMd5Hash(String string) {
        String string2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string3 = string;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            messageDigest.update(bytes);
            string2 = new BigInteger(1, messageDigest.digest()).toString(32);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (Exception var4) {
            throw new RuntimeException("Could not hash input string.", var4);
        }
        return string2;
    }

    private static final void downloadAndInstallMaven$lambda$1(ProgressIndicator $indicator, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String username = Environment.Companion.getVariable("MVNW_USERNAME");
        String password = Environment.Companion.getVariable("MVNW_PASSWORD");
        Object object = username;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && !((object = (CharSequence)password) == null || StringsKt.isBlank((CharSequence)object))) {
            ProgressIndicator progressIndicator = $indicator;
            if (progressIndicator != null) {
                object = progressIndicator;
                CharSequence $this$downloadAndInstallMaven_u24lambda_u241_u240 = object;
                boolean bl = false;
                $this$downloadAndInstallMaven_u24lambda_u241_u240.setText(SyncBundle.message("maven.sync.wrapper.downloading.auth", new Object[0]));
            }
            Base64.Encoder encoder = Base64.getEncoder();
            object = username + ":" + password;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.setRequestProperty("Authorization", "Basic " + encoder.encodeToString(byArray));
        }
    }

    private static final boolean unzip$lambda$4$0(Path $zip, Path it) {
        return !Intrinsics.areEqual((Object)it.getFileName(), (Object)$zip.getFileName());
    }

    private static final boolean unzip$lambda$4$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit unzip$lambda$4$2(MavenWrapperSupport this$0, Path it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.deleteRecursively(it);
        return Unit.INSTANCE;
    }

    private static final void unzip$lambda$4$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit deleteRecursively$lambda$0(Path it) {
        Files.deleteIfExists(it);
        return Unit.INSTANCE;
    }

    private static final void deleteRecursively$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @Nullable
    public static final String getWrapperDistributionUrl(@Nullable Path baseDir) {
        return Companion.getWrapperDistributionUrl(baseDir);
    }

    @JvmStatic
    public static final void showUnsecureWarning(@NotNull MavenSyncConsole console, @Nullable Path mavenProjectMultimodulePath) {
        Companion.showUnsecureWarning(console, mavenProjectMultimodulePath);
    }

    @JvmStatic
    @Nullable
    public static final MavenDistribution getCurrentDistribution(@NotNull Project project, @NotNull String urlString) {
        return Companion.getCurrentDistribution(project, urlString);
    }

    @JvmStatic
    @Nullable
    public static final Path getWrapperProperties(@Nullable Path baseDir) {
        return Companion.getWrapperProperties(baseDir);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion;", "", "<init>", "()V", "DISTRIBUTION_URL_PROPERTY", "", "getWrapperDistributionUrl", "baseDir", "Ljava/nio/file/Path;", "showUnsecureWarning", "", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "mavenProjectMultimodulePath", "createDistributionKey", "project", "Lcom/intellij/openapi/project/Project;", "urlString", "setDistributionPath", "path", "getCurrentDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "getWrapperProperties", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenWrapperSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n363#2,7:289\n1#3:296\n*S KotlinDebug\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion\n*L\n247#1:289,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String getWrapperDistributionUrl(@Nullable Path baseDir) {
            try {
                Path path = this.getWrapperProperties(baseDir);
                if (path == null) {
                    return null;
                }
                Path wrapperProperties = path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(wrapperProperties, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return null;
                }
                Properties properties = new Properties();
                byte[] byArray = Files.readAllBytes(wrapperProperties);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                ByteArrayInputStream stream = new ByteArrayInputStream(byArray);
                properties.load(stream);
                String configuredProperty = properties.getProperty(DISTRIBUTION_URL_PROPERTY);
                String urlBase = Environment.Companion.getVariable("MVNW_REPOURL");
                String string = configuredProperty;
                int configuredUrlBaseEnd = string != null ? StringsKt.indexOf$default((CharSequence)string, (String)"/org/apache/maven", (int)0, (boolean)false, (int)6, null) : -1;
                CharSequence charSequence = urlBase;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && configuredUrlBaseEnd >= 0) {
                    String string2;
                    if (StringsKt.endsWith$default((CharSequence)urlBase, (char)'/', (boolean)false, (int)2, null)) {
                        String string3 = urlBase.substring(0, urlBase.length() - 1);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    } else {
                        string2 = urlBase;
                    }
                    Intrinsics.checkNotNull((Object)configuredProperty);
                    String string4 = configuredProperty.substring(configuredUrlBaseEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    return string2 + string4;
                }
                return configuredProperty;
            }
            catch (IOException e) {
                MavenLog.LOG.warn("exception reading wrapper url", (Throwable)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        public final void showUnsecureWarning(@NotNull MavenSyncConsole console, @Nullable Path mavenProjectMultimodulePath) {
            FilePosition filePosition;
            int n;
            Path properties;
            block4: {
                Iterator iterator;
                int index$iv;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
                        properties = this.getWrapperProperties(mavenProjectMultimodulePath);
                        Iterable<Path> iterable = properties;
                        if (iterable == null) break block5;
                        Path path = iterable;
                        List<String> list = Files.readAllLines(path, Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                        iterable = list;
                        if (list == null) break block5;
                        Iterable<Path> $this$indexOfFirst$iv = iterable;
                        boolean $i$f$indexOfFirst = false;
                        index$iv = 0;
                        iterator = $this$indexOfFirst$iv.iterator();
                        break block6;
                    }
                    n = -1;
                    break block4;
                }
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    String it = (String)e;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)DISTRIBUTION_URL_PROPERTY, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int line = n;
            Path path = properties;
            if (path != null) {
                Path it = path;
                boolean bl = false;
                filePosition = new FilePosition(it.toFile(), line, 0);
            } else {
                filePosition = null;
            }
            FilePosition position = filePosition;
            String string = SyncBundle.message("maven.sync.wrapper.http.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.sync.wrapper.http.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            console.addWarning(string, string2, position);
        }

        private final String createDistributionKey(Project project, String urlString) {
            EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
            return Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE) ? urlString : eelDescriptor + ":" + urlString;
        }

        public final void setDistributionPath(@NotNull Project project, @NotNull String urlString, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            ((Map)MavenWrapperMapping.Companion.getInstance().getMyState$intellij_maven().mapping).put(this.createDistributionKey(project, urlString), ((Object)path.toAbsolutePath()).toString());
        }

        @JvmStatic
        @Nullable
        public final MavenDistribution getCurrentDistribution(@NotNull Project project, @NotNull String urlString) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            MavenWrapperMapping mapping = MavenWrapperMapping.Companion.getInstance();
            String key = this.createDistributionKey(project, urlString);
            String cachedHome = mapping.getMyState$intellij_maven().mapping.get(key);
            if (cachedHome != null) {
                Path path = Path.of(cachedHome, new String[0]);
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return new LocalMavenDistribution(path, urlString);
                }
                mapping.getMyState$intellij_maven().mapping.remove(key);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Path getWrapperProperties(@Nullable Path baseDir) {
            Path path = baseDir;
            return path != null && (path = path.resolve(".mvn")) != null && (path = path.resolve("wrapper")) != null ? path.resolve("maven-wrapper.properties") : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

