/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class RoundPxValueQuickFix
implements LocalQuickFix {
    private static final String EMPTY_STRING = "";

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.inspections.float.px.length.fix.message", (Object[])new Object[0]);
        if (string == null) {
            RoundPxValueQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            RoundPxValueQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RoundPxValueQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor.getPsiElement()) instanceof CssTokenImpl) {
            String elementText = element.getText();
            try {
                double doubleValue = Double.parseDouble(elementText);
                ((CssTokenImpl)element).replaceWithText(String.valueOf(Math.round(doubleValue)));
            }
            catch (NumberFormatException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)CssBundle.message((String)"css.inspections.float.px.length.fix.error", (Object[])new Object[]{elementText}), (String)EMPTY_STRING, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/RoundPxValueQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/RoundPxValueQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

