/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;

public interface ConfigPlaceholderReference {
    @NonNls
    public static final String PLACEHOLDER_PREFIX = "${";
    @NonNls
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static PsiReference[] createPlaceholderReferences(PsiElement element, BiFunction<? super PsiElement, ? super TextRange, ? extends PsiReference> producer) {
        String text = ElementManipulators.getValueText((PsiElement)element);
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        if (ranges.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> placeholderReferences = new ArrayList<PsiReference>(ranges.size());
        int startOffset = ElementManipulators.getOffsetInElement((PsiElement)element);
        for (TextRange range : ranges) {
            int colonIdx = range.substring(text).indexOf(58);
            if (colonIdx != -1) {
                range = TextRange.from((int)range.getStartOffset(), (int)colonIdx);
            }
            placeholderReferences.add(producer.apply((PsiElement)element, (TextRange)range.shiftRight(startOffset)));
        }
        return placeholderReferences.toArray(PsiReference.EMPTY_ARRAY);
    }
}

