/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="branch-storage")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0006J*\u0010\u0016\u001a\u0004\u0018\u00010\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\f0\u0006\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b*\u0004\u0018\u00010\u0011H\u0002R-\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/dvcs/branch/BranchStorage;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "branches", "", "", "", "Lcom/intellij/dvcs/branch/DvcsBranchInfo;", "getBranches", "()Ljava/util/Map;", "branches$delegate", "Lkotlin/properties/ReadWriteProperty;", "contains", "", "typeName", "repositoryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "branchName", "add", "", "remove", "find", "", "sourceBranch", "pathOrEmpty", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.dvcs.impl.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBranchStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchStorage.kt\ncom/intellij/dvcs/branch/BranchStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class BranchStorage
extends BaseState {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty branches$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

    @Property(surroundWithTag=false)
    @MapAnnotation(keyAttributeName="type")
    @NotNull
    public final Map<String, List<DvcsBranchInfo>> getBranches() {
        return (Map)this.branches$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final boolean contains(@NotNull String typeName, @Nullable VirtualFile repositoryRoot, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        List<DvcsBranchInfo> list = this.getBranches().get(typeName);
        if (list == null) {
            return false;
        }
        List<DvcsBranchInfo> branches = list;
        return this.find((Collection<? extends DvcsBranchInfo>)branches, repositoryRoot, branchName) != null;
    }

    public final void add(@NotNull String typeName, @Nullable VirtualFile repositoryRoot, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (this.contains(typeName, repositoryRoot, branchName)) {
            return;
        }
        this.getBranches().computeIfAbsent(typeName, arg_0 -> BranchStorage.add$lambda$1(BranchStorage::add$lambda$0, arg_0)).add(new DvcsBranchInfo(this.pathOrEmpty(repositoryRoot), branchName));
        this.intIncrementModificationCount();
    }

    public final void remove(@NotNull String typeName, @Nullable VirtualFile repositoryRoot, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        List<DvcsBranchInfo> list = this.getBranches().get(typeName);
        if (list == null) {
            return;
        }
        List<DvcsBranchInfo> branches = list;
        DvcsBranchInfo dvcsBranchInfo = this.find((Collection<? extends DvcsBranchInfo>)branches, repositoryRoot, branchName);
        if (dvcsBranchInfo == null) {
            return;
        }
        DvcsBranchInfo toDelete = dvcsBranchInfo;
        branches.remove(toDelete);
        if (branches.isEmpty()) {
            this.getBranches().remove(typeName);
        }
        this.intIncrementModificationCount();
    }

    private final DvcsBranchInfo find(Collection<? extends DvcsBranchInfo> branches, VirtualFile repositoryRoot, String sourceBranch) {
        Object v0;
        block1: {
            Iterable iterable = branches;
            for (Object t : iterable) {
                DvcsBranchInfo it = (DvcsBranchInfo)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.sourceName, (Object)sourceBranch) && Intrinsics.areEqual((Object)this.pathOrEmpty(repositoryRoot), (Object)it.repoPath))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String pathOrEmpty(VirtualFile $this$pathOrEmpty) {
        Object object = $this$pathOrEmpty;
        if (object == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }

    private static final List add$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List add$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BranchStorage.class, "branches", "getBranches()Ljava/util/Map;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

