/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteRun.gradle;

import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMapper;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/remoteRun/gradle/GradleOnSshExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "<init>", "()V", "prepareExecution", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "externalProjectPath", "", "isPreviewMode", "", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "projectPath", "isRemoteRun", "SshEnvironmentConfigurationProvider", "intellij.remoteRun.gradle"})
public final class GradleOnSshExecutionAware
implements GradleExecutionAware {
    public void prepareExecution(@NotNull ExternalSystemTask task, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(runConfiguration, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return null;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        if (!(environmentConfigurationProvider.getEnvironmentConfiguration() instanceof SshTargetEnvironmentConfiguration)) {
            return null;
        }
        return (TargetEnvironmentConfigurationProvider)new SshEnvironmentConfigurationProvider(project, environmentConfigurationProvider);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(projectPath, isPreviewMode, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return null;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        if (!(environmentConfigurationProvider.getEnvironmentConfiguration() instanceof SshTargetEnvironmentConfiguration)) {
            return null;
        }
        return (TargetEnvironmentConfigurationProvider)new SshEnvironmentConfigurationProvider(project, environmentConfigurationProvider);
    }

    public boolean isRemoteRun(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(runConfiguration, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return false;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        TargetEnvironmentConfiguration environmentConfiguration = environmentConfigurationProvider.getEnvironmentConfiguration();
        return environmentConfiguration instanceof SshTargetEnvironmentConfiguration;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\"\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/remoteRun/gradle/GradleOnSshExecutionAware$SshEnvironmentConfigurationProvider;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;)V", "environmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "pathMapper", "Lcom/intellij/util/PathMapper;", "getPathMapper", "()Lcom/intellij/util/PathMapper;", "getServerBindingAddress", "Lcom/intellij/execution/target/HostPort;", "targetEnvironmentConfiguration", "getClientCommunicationAddress", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "gradleServerHostPort", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "intellij.remoteRun.gradle"})
    private static final class SshEnvironmentConfigurationProvider
    implements GradleServerConfigurationProvider {
        @NotNull
        private final Project project;
        @NotNull
        private final TargetEnvironmentConfigurationProvider environmentConfigurationProvider;

        public SshEnvironmentConfigurationProvider(@NotNull Project project, @NotNull TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environmentConfigurationProvider, (String)"environmentConfigurationProvider");
            this.project = project;
            this.environmentConfigurationProvider = environmentConfigurationProvider;
        }

        @NotNull
        public TargetEnvironmentConfiguration getEnvironmentConfiguration() {
            return this.environmentConfigurationProvider.getEnvironmentConfiguration();
        }

        @Nullable
        public PathMapper getPathMapper() {
            return this.environmentConfigurationProvider.getPathMapper();
        }

        @NotNull
        public HostPort getServerBindingAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            String string = this.getRemoteCredentials(targetEnvironmentConfiguration).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            return new HostPort(string, 0);
        }

        @NotNull
        public HostPort getClientCommunicationAddress(@Nullable ExternalSystemTaskId taskId, @NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration, @NotNull HostPort gradleServerHostPort) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            Intrinsics.checkNotNullParameter((Object)gradleServerHostPort, (String)"gradleServerHostPort");
            RemoteCredentials remoteCredentials = this.getRemoteCredentials(targetEnvironmentConfiguration);
            String string = remoteCredentials.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            return new HostPort(string, gradleServerHostPort.getPort());
        }

        private final RemoteCredentials getRemoteCredentials(TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNull((Object)targetEnvironmentConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration");
            RemoteCredentials remoteCredentials = ((SshTargetEnvironmentConfiguration)targetEnvironmentConfiguration).findRemoteCredentials(this.project);
            if (remoteCredentials == null) {
                Object[] objectArray = new Object[]{targetEnvironmentConfiguration.getDisplayName()};
                String string = RemoteSdkBundle.message((String)"no.ssh.configuration.for.0", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                throw new IllegalStateException(string2.toString());
            }
            return remoteCredentials;
        }
    }
}

