/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public final class PerforceInfoAndClient {
    private static final Logger LOG = Logger.getInstance(PerforceInfoAndClient.class);

    @NotNull
    static ConnectionInfo calcInfo(@NotNull P4Connection connection, @NotNull PerforceRunner runner, @NotNull ClientRootsCache clientRootsCache) {
        if (connection == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(1);
        }
        if (clientRootsCache == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(2);
        }
        try {
            Map<String, List<String>> infoMap = PerforceInfoAndClient.calcInfoMap(connection, runner);
            return new ConnectionInfo(infoMap, new ClientData(PerforceInfoAndClient.calcClientMap(connection, runner, PerforceInfoAndClient.extractClient(infoMap), clientRootsCache)));
        }
        catch (PerforceAuthenticationException e) {
            return new ConnectionInfo((VcsException)((Object)e));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return new ConnectionInfo(e);
        }
    }

    private static String extractClient(Map<String, List<String>> infoMap) throws VcsException {
        List<String> clientValue = infoMap.get("Client name:");
        if (clientValue == null || clientValue.isEmpty()) {
            throw new VcsException(PerforceBundle.message("error.no.client.name.in.info.specification.found", new Object[0]));
        }
        return clientValue.get(0);
    }

    @NotNull
    private static Map<String, List<String>> calcClientMap(@NotNull P4Connection connection, @NotNull PerforceRunner runner, @NotNull String client, @NotNull ClientRootsCache clientRootsCache) throws VcsException {
        if (connection == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(4);
        }
        if (client == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(5);
        }
        if (clientRootsCache == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(6);
        }
        Map<String, List<String>> clientMap = runner.loadClient(client, connection);
        PerforceInfoAndClient.convertRoots(clientMap, "Root:", clientRootsCache);
        PerforceInfoAndClient.convertRoots(clientMap, "AltRoots:", clientRootsCache);
        Map<String, List<String>> map = clientMap;
        if (map == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    private static Map<String, List<String>> calcInfoMap(@NotNull P4Connection connection, @NotNull PerforceRunner runner) throws VcsException {
        Map<String, List<String>> infoMap;
        if (connection == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(8);
        }
        if (runner == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(9);
        }
        if ((infoMap = runner.getInfo(connection)).containsKey("Client unknown.")) {
            throw new VcsException(PerforceBundle.message("error.client.unknown", new Object[0]));
        }
        infoMap.remove("Client address:");
        infoMap.remove("Server date:");
        infoMap.remove("Client address:");
        Map<String, List<String>> map = infoMap;
        if (map == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(10);
        }
        return map;
    }

    public static RefreshInfo recalculateInfos(@NotNull Map<P4Connection, ConnectionInfo> old, @NotNull Collection<? extends P4Connection> allConnections, @NotNull PerforceRunner runner, @NotNull ClientRootsCache clientRootsCache) {
        if (old == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(11);
        }
        if (allConnections == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(12);
        }
        if (runner == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(13);
        }
        if (clientRootsCache == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(14);
        }
        Map<P4Connection, ConnectionInfo> newMap = PerforceInfoAndClient.calculateInfos(allConnections, runner, clientRootsCache);
        boolean hasErrors = newMap.values().stream().anyMatch(ConnectionInfo::hasErrorsBesidesAuthentication);
        HashMap<P4Connection, ConnectionInfo> info = new HashMap<P4Connection, ConnectionInfo>();
        if (hasErrors) {
            info.putAll(old);
        }
        info.putAll(newMap);
        return new RefreshInfo(Collections.unmodifiableMap(info), hasErrors);
    }

    public static Map<P4Connection, ConnectionInfo> calculateInfos(@NotNull Collection<? extends P4Connection> allConnections, @NotNull PerforceRunner runner, @NotNull ClientRootsCache clientRootsCache) {
        if (allConnections == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(15);
        }
        if (runner == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(16);
        }
        if (clientRootsCache == null) {
            PerforceInfoAndClient.$$$reportNull$$$0(17);
        }
        HashMap<ConnectionKey, ConnectionInfo> cache = new HashMap<ConnectionKey, ConnectionInfo>();
        HashMap<P4Connection, ConnectionInfo> newMap = new HashMap<P4Connection, ConnectionInfo>();
        for (P4Connection p4Connection : allConnections) {
            ConnectionKey key = p4Connection.getConnectionKey();
            ConnectionInfo info = (ConnectionInfo)cache.get(key);
            if (info == null) {
                info = PerforceInfoAndClient.calcInfo(p4Connection, runner, clientRootsCache);
                cache.put(key, info);
            }
            newMap.put(p4Connection, info);
        }
        return newMap;
    }

    private static void convertRoots(Map<String, List<String>> clientSpec, String key, ClientRootsCache clientRootsCache) {
        List<String> in = clientSpec.get(key);
        if (in == null) {
            return;
        }
        ArrayList<String> out = new ArrayList<String>(in.size());
        for (String s : in) {
            out.add(clientRootsCache.putGet(s));
        }
        clientSpec.put(key, out);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 6: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientRootsCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceInfoAndClient";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allConnections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceInfoAndClient";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcClientMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInfoMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcClientMap";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcInfoMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "recalculateInfos";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calculateInfos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }

    public static class RefreshInfo {
        public final Map<P4Connection, ConnectionInfo> newInfo;
        public final boolean hasAnyErrorsBesidesAuthentication;

        public RefreshInfo(Map<P4Connection, ConnectionInfo> newInfo, boolean hasAnyErrorsBesidesAuthentication) {
            this.newInfo = newInfo;
            this.hasAnyErrorsBesidesAuthentication = hasAnyErrorsBesidesAuthentication;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hasAnyErrorsBesidesAuthentication", this.hasAnyErrorsBesidesAuthentication).add("newInfo", this.newInfo).toString();
        }
    }
}

