/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSControlFlowScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowBuilder;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSBranchInstruction;
import com.intellij.lang.javascript.psi.types.guard.JSInjectionControlFlowUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.expr.psi.VueJSEmbeddedExpressionContent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u001a\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u001c\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0014J\u0018\u0010$\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020%H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u00020\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder;", "Lcom/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder;", "<init>", "()V", "visitingModeOverrides", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder$HtmlTagVisitingMode;", "value", "visitingMode", "getVisitingMode", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder$HtmlTagVisitingMode;", "setVisitingMode", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder$HtmlTagVisitingMode;)V", "delayedPendingEdges", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/codeInsight/controlflow/Instruction;", "addDelayedPendingEdge", "", "pendingScope", "instruction", "flushDelayedPendingEdges", "addPendingEdgeFromBranching", "owner", "doBuild", "scope", "Lcom/intellij/lang/javascript/psi/JSControlFlowScope;", "visitElement", "element", "currentTopConditionExpression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "isStatementCondition", "", "parent", "currentElement", "processIfBranching", "Lcom/intellij/psi/html/HtmlTag;", "conditionAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "visitJSConditionalExpression", "node", "Lcom/intellij/lang/javascript/psi/JSConditionalExpression;", "findElseBranch", "initialElement", "Companion", "HtmlTagVisitingMode", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueControlFlowBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueControlFlowBuilder.kt\norg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1#2:165\n1915#3,2:166\n*S KotlinDebug\n*F\n+ 1 VueControlFlowBuilder.kt\norg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder\n*L\n54#1:166,2\n*E\n"})
public final class VueControlFlowBuilder
extends JSControlFlowBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<PsiElement, HtmlTagVisitingMode> visitingModeOverrides = new LinkedHashMap();
    @NotNull
    private final List<Pair<PsiElement, Instruction>> delayedPendingEdges = new ArrayList();
    @Nullable
    private JSExpression currentTopConditionExpression;
    @NotNull
    private static final String V_IF = "v-if";
    @NotNull
    private static final String V_ELSE_IF = "v-else-if";
    @NotNull
    private static final String V_ELSE = "v-else";
    @NotNull
    private static final Set<String> controlFlowRelevantDirectives;

    private final HtmlTagVisitingMode getVisitingMode(PsiElement $this$visitingMode) {
        HtmlTagVisitingMode htmlTagVisitingMode = this.visitingModeOverrides.get($this$visitingMode);
        if (htmlTagVisitingMode == null) {
            htmlTagVisitingMode = HtmlTagVisitingMode.Default;
        }
        return htmlTagVisitingMode;
    }

    private final void setVisitingMode(PsiElement $this$visitingMode, HtmlTagVisitingMode value) {
        Unit unit;
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.visitingModeOverrides.put($this$visitingMode, value);
    }

    private final void addDelayedPendingEdge(PsiElement pendingScope, Instruction instruction) {
        if (instruction == null) {
            return;
        }
        Pair pair = Pair.create((Object)pendingScope, (Object)instruction);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        this.delayedPendingEdges.add((Pair<PsiElement, Instruction>)pair);
    }

    private final void flushDelayedPendingEdges() {
        Iterable $this$forEach$iv = this.delayedPendingEdges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
        this.delayedPendingEdges.clear();
    }

    protected void addPendingEdgeFromBranching(@NotNull PsiElement owner, @Nullable Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.addDelayedPendingEdge(owner, instruction);
    }

    protected void doBuild(@NotNull JSControlFlowScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super.doBuild(scope);
        this.visitingModeOverrides.clear();
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof HtmlTag) {
            XmlAttribute conditionAttribute = null;
            if (this.getVisitingMode(element) == HtmlTagVisitingMode.VisitChildren) {
                super.visitElement(element);
                this.setVisitingMode(element, HtmlTagVisitingMode.Skip);
            } else if (this.getVisitingMode(element) != HtmlTagVisitingMode.Skip) {
                XmlAttribute xmlAttribute;
                XmlAttribute it = xmlAttribute = ((HtmlTag)element).getAttribute(V_IF);
                boolean bl = false;
                conditionAttribute = it;
                if (xmlAttribute != null) {
                    HtmlTag htmlTag = (HtmlTag)element;
                    XmlAttribute xmlAttribute2 = conditionAttribute;
                    Intrinsics.checkNotNull((Object)xmlAttribute2);
                    this.processIfBranching(htmlTag, xmlAttribute2);
                    this.flushDelayedPendingEdges();
                } else {
                    it = xmlAttribute = ((HtmlTag)element).getAttribute(V_ELSE_IF);
                    boolean bl2 = false;
                    conditionAttribute = it;
                    if (xmlAttribute != null) {
                        HtmlTag htmlTag = (HtmlTag)element;
                        XmlAttribute xmlAttribute3 = conditionAttribute;
                        Intrinsics.checkNotNull((Object)xmlAttribute3);
                        this.processIfBranching(htmlTag, xmlAttribute3);
                    } else {
                        it = xmlAttribute = ((HtmlTag)element).getAttribute(V_ELSE);
                        boolean bl3 = false;
                        conditionAttribute = it;
                        if (xmlAttribute != null) {
                            super.visitElement(element);
                            this.setVisitingMode(element, HtmlTagVisitingMode.Skip);
                        } else {
                            super.visitElement(element);
                        }
                    }
                }
            }
        } else if (psiElement instanceof XmlAttribute) {
            if (controlFlowRelevantDirectives.contains(((XmlAttribute)element).getName())) {
                return;
            }
            super.visitElement(element);
        } else if (psiElement instanceof JSExpression) {
            super.visitElement(element);
        } else if (psiElement instanceof VueJSEmbeddedExpressionContent) {
            this.myBuilder.startNode(element);
            super.visitElement(element);
        } else if (psiElement instanceof XmlText) {
            List injectedFiles = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element);
            if (injectedFiles != null) {
                this.myBuilder.startNode(element);
                for (Pair pair : injectedFiles) {
                    PsiElement injectedFile = (PsiElement)pair.first;
                    Intrinsics.checkNotNull((Object)injectedFile);
                    if (!JSInjectionControlFlowUtil.isCfgAwareInjectedFile((PsiElement)injectedFile)) continue;
                    this.myBuilder.startNode(injectedFile);
                }
            }
        } else {
            super.visitElement(element);
        }
    }

    protected boolean isStatementCondition(@Nullable PsiElement parent, @Nullable PsiElement currentElement) {
        return Intrinsics.areEqual((Object)currentElement, (Object)this.currentTopConditionExpression);
    }

    private final void processIfBranching(HtmlTag element, XmlAttribute conditionAttribute) {
        JSExpression conditionExpression = (JSExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)conditionAttribute.getValueElement()), JSExpression.class);
        this.setVisitingMode((PsiElement)element, HtmlTagVisitingMode.VisitChildren);
        this.myBuilder.startNode((PsiElement)element);
        this.currentTopConditionExpression = conditionExpression;
        this.processBranching((PsiElement)element, conditionExpression, (PsiElement)element, this.findElseBranch(element), JSBranchInstruction.BranchOwner.IF);
        this.currentTopConditionExpression = null;
    }

    public void visitJSConditionalExpression(@NotNull JSConditionalExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super.visitJSConditionalExpression(node);
        this.flushDelayedPendingEdges();
    }

    private final PsiElement findElseBranch(HtmlTag initialElement) {
        PsiElement element = initialElement.getNextSibling();
        if (element instanceof XmlText) {
            element = ((XmlText)element).getNextSibling();
        }
        if (element instanceof HtmlTag) {
            XmlAttribute xmlAttribute = ((HtmlTag)element).getAttribute(V_ELSE_IF);
            if (xmlAttribute == null && (xmlAttribute = ((HtmlTag)element).getAttribute(V_ELSE)) == null) {
                return null;
            }
            return element;
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{V_IF, V_ELSE_IF, V_ELSE};
        controlFlowRelevantDirectives = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder$Companion;", "", "<init>", "()V", "V_IF", "", "V_ELSE_IF", "V_ELSE", "controlFlowRelevantDirectives", "", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/vuejs/codeInsight/controlflow/VueControlFlowBuilder$HtmlTagVisitingMode;", "", "<init>", "(Ljava/lang/String;I)V", "Default", "VisitChildren", "Skip", "intellij.vuejs.backend"})
    public static final class HtmlTagVisitingMode
    extends Enum<HtmlTagVisitingMode> {
        public static final /* enum */ HtmlTagVisitingMode Default = new HtmlTagVisitingMode();
        public static final /* enum */ HtmlTagVisitingMode VisitChildren = new HtmlTagVisitingMode();
        public static final /* enum */ HtmlTagVisitingMode Skip = new HtmlTagVisitingMode();
        private static final /* synthetic */ HtmlTagVisitingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HtmlTagVisitingMode[] values() {
            return (HtmlTagVisitingMode[])$VALUES.clone();
        }

        public static HtmlTagVisitingMode valueOf(String value) {
            return Enum.valueOf(HtmlTagVisitingMode.class, value);
        }

        @NotNull
        public static EnumEntries<HtmlTagVisitingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = htmlTagVisitingModeArray = new HtmlTagVisitingMode[]{HtmlTagVisitingMode.Default, HtmlTagVisitingMode.VisitChildren, HtmlTagVisitingMode.Skip};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

