/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.source.VueDeclarations;
import org.jetbrains.vuejs.model.typed.VueTypedDirectiveModifier;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedDirectives;", "", "<init>", "()V", "getDirectiveModifiers", "", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "source", "Lcom/intellij/psi/PsiElement;", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "getDirectiveModifiersInternal", "getClassicDirectiveModifiersType", "Lcom/intellij/lang/javascript/psi/JSType;", "functionParameterType", "parameterIndex", "", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueTypedDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueTypedDirectives.kt\norg/jetbrains/vuejs/model/typed/VueTypedDirectives\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1586#2:101\n1661#2,3:102\n*S KotlinDebug\n*F\n+ 1 VueTypedDirectives.kt\norg/jetbrains/vuejs/model/typed/VueTypedDirectives\n*L\n47#1:101\n47#1:102,3\n*E\n"})
public final class VueTypedDirectives {
    @NotNull
    public static final VueTypedDirectives INSTANCE = new VueTypedDirectives();

    private VueTypedDirectives() {
    }

    @NotNull
    public final List<VueDirectiveModifier> getDirectiveModifiers(@NotNull PsiElement source, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        PsiElement psiElement = VueDeclarations.INSTANCE.findDeclaration(source);
        if (psiElement == null) {
            psiElement = source;
        }
        return this.getDirectiveModifiersInternal(psiElement, mode);
    }

    @NotNull
    public final List<VueDirectiveModifier> getDirectiveModifiers(@NotNull TypeScriptPropertySignature source, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.getDirectiveModifiersInternal((PsiElement)source, mode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VueDirectiveModifier> getDirectiveModifiersInternal(PsiElement source, VueMode mode) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JSType modifiersType;
        if ((modifiersType = (switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> this.getClassicDirectiveModifiersType(source);
            case 2 -> this.functionParameterType(source, 3);
            default -> throw new NoWhenBranchMatchedException();
        })) == null) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = modifiersType.asRecordType().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getProperties(...)");
        iterable = iterable;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void property;
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = property;
            PsiElement source2 = var13_13 instanceof PsiElement ? (PsiElement)property : (var13_13 instanceof JSRecordType.TypeMember ? property.getMemberSource().getSingleElement() : null);
            String string = property.getMemberName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
            collection.add(new VueTypedDirectiveModifier(string, source2));
        }
        return (List)destination$iv$iv;
    }

    private final JSType getClassicDirectiveModifiersType(PsiElement source) {
        JSType jSType;
        if (!(source instanceof JSTypeOwner)) {
            return null;
        }
        JSType jSType2 = ((JSTypeOwner)source).getJSType();
        if (jSType2 == null) {
            return null;
        }
        JSType jsType = jSType2;
        JSRecordType.PropertySignature propertySignature = jsType.asRecordType().findPropertySignature("mounted");
        if (propertySignature == null) {
            return null;
        }
        JSRecordType.PropertySignature mounted = propertySignature;
        JSType jSType3 = mounted.getJSType();
        if (jSType3 == null || (jSType = this.functionParameterType(jSType3, 1)) == null) {
            return null;
        }
        JSType bindingType = jSType;
        jSType3 = bindingType.asRecordType().findPropertySignature("modifiers");
        return jSType3 != null ? jSType3.getJSType() : null;
    }

    private final JSType functionParameterType(PsiElement $this$functionParameterType, int parameterIndex) {
        Object object;
        PsiElement psiElement = $this$functionParameterType;
        if (psiElement instanceof JSFunction) {
            JSParameterListElement[] jSParameterListElementArray = ((JSFunction)$this$functionParameterType).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)jSParameterListElementArray, (String)"getParameters(...)");
            JSParameterListElement jSParameterListElement = (JSParameterListElement)ArraysKt.getOrNull((Object[])jSParameterListElementArray, (int)parameterIndex);
            object = jSParameterListElement != null ? jSParameterListElement.getJSType() : null;
        } else if (psiElement instanceof JSTypeOwner) {
            JSType jSType = ((JSTypeOwner)$this$functionParameterType).getJSType();
            object = jSType != null ? this.functionParameterType(jSType, parameterIndex) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final JSType functionParameterType(JSType $this$functionParameterType, int parameterIndex) {
        JSType jSType = $this$functionParameterType.substitute();
        JSFunctionType jSFunctionType = jSType instanceof JSFunctionType ? (JSFunctionType)jSType : null;
        if (jSFunctionType == null) {
            return null;
        }
        JSFunctionType functionType = jSFunctionType;
        List list = functionType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        JSParameterTypeDecorator jSParameterTypeDecorator = (JSParameterTypeDecorator)CollectionsKt.getOrNull((List)list, (int)parameterIndex);
        return jSParameterTypeDecorator != null ? jSParameterTypeDecorator.getSimpleType() : null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueMode.values().length];
            try {
                nArray[VueMode.CLASSIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueMode.VAPOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

