/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconWithOverlay;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/SpringBootIconWithOverlay;", "Lcom/intellij/ui/icons/IconWithOverlay;", "mainIcon", "Ljavax/swing/Icon;", "overlayIcon", "<init>", "(Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "(Ljavax/swing/Icon;)V", "getOverlayShape", "Ljava/awt/Shape;", "x", "", "y", "replaceBy", "Lcom/intellij/ui/LayeredIcon;", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "copy", "intellij.spring.boot.core"})
public final class SpringBootIconWithOverlay
extends IconWithOverlay {
    private SpringBootIconWithOverlay(Icon mainIcon, Icon overlayIcon) {
        super(mainIcon, overlayIcon);
    }

    public SpringBootIconWithOverlay(@NotNull Icon mainIcon) {
        Intrinsics.checkNotNullParameter((Object)mainIcon, (String)"mainIcon");
        Icon icon = SpringBootApiIcons.SpringBoot_Overlay;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringBoot_Overlay");
        this(mainIcon, icon);
    }

    @Nullable
    public Shape getOverlayShape(int x, int y) {
        if (!ExperimentalUI.Companion.isNewUI()) {
            return null;
        }
        float scale = this.getScale();
        double r = (double)scale * 4.5;
        Icon icon = this.getOverlayIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getOverlayIcon(...)");
        Icon overlayIcon = icon;
        int w = overlayIcon.getIconWidth();
        int h = overlayIcon.getIconHeight();
        return new Ellipse2D.Double((double)(x + w) - (double)2 * r + (double)scale, (double)(y + h) - (double)2 * r + (double)scale, (double)2 * r, (double)2 * r);
    }

    @NotNull
    public LayeredIcon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        Icon icon = replacer.replaceIcon(this.getMainIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        Icon icon2 = replacer.replaceIcon(this.getOverlayIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"replaceIcon(...)");
        return (LayeredIcon)new SpringBootIconWithOverlay(icon, icon2);
    }

    @NotNull
    public LayeredIcon copy() {
        Icon icon = this.getMainIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getMainIcon(...)");
        return (LayeredIcon)new SpringBootIconWithOverlay(icon);
    }
}

