/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.application.SpringBootMainUtil;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringBootApplicationServiceImpl
implements SpringBootApplicationService {
    private static final ElementPattern<UCallExpression> RUN_METHOD_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{UastPatterns.callExpression().withMethodName("run").withAnyResolvedMethod((ElementPattern)PsiJavaPatterns.psiMethod().definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.springframework.boot.SpringApplication", "org.springframework.boot.SpringApplication.Augmented", "org.springframework.boot.builder.SpringApplicationBuilder"})))), UastPatterns.callExpression().withMethodName("runApplication").withAnyResolvedMethod((ElementPattern)PsiJavaPatterns.psiMethod().definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName("org.springframework.boot.SpringApplicationExtensionsKt")))});

    SpringBootApplicationServiceImpl() {
    }

    public boolean isSpringApplication(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootApplicationServiceImpl.$$$reportNull$$$0(0);
        }
        return SpringBootMainUtil.isNotPrivateMain((PsiClass)psiClass) && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, Collections.singletonList("org.springframework.boot.autoconfigure.EnableAutoConfiguration"));
    }

    public List<PsiClass> getSpringApplications(Module module) {
        if (module.isDisposed() || DumbService.isDumb((Project)module.getProject()) || SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration") == null) {
            return List.of();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            JamService jamService = JamService.getJamService((Project)module.getProject());
            GlobalSearchScope scope = module.getModuleScope(false);
            ArrayList<String> fqns = new ArrayList<String>((Collection)EnableAutoConfiguration.getAnnotations().apply(module));
            fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
            SmartList applications = new SmartList();
            for (String fqn : fqns) {
                List elements = jamService.getJamClassElements(EnableAutoConfiguration.JAM_KEY, fqn, scope);
                for (EnableAutoConfiguration element : elements) {
                    PsiClass annotatedClass = (PsiClass)element.getPsiElement();
                    if (!SpringBootMainUtil.isNotPrivateMain((PsiClass)annotatedClass)) continue;
                    applications.add(annotatedClass);
                }
            }
            return CachedValueProvider.Result.create((Object)applications, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public boolean hasMainMethod(PsiClass springBootClass) {
        return UastUtils.findMainInClass((UClass)((UClass)UastContextKt.toUElement((PsiElement)this.findMainClassCandidate(springBootClass), UClass.class))) != null;
    }

    @Nullable
    public PsiClass findMainClassCandidate(@Nullable PsiClass springBootClass) {
        if (springBootClass == null) {
            return null;
        }
        UFile file = (UFile)UastContextKt.getUastParentOfType((PsiElement)springBootClass, UFile.class);
        if (file == null) {
            return springBootClass;
        }
        List<PsiClass> mainClassCandidates = file.getClasses().stream().map(UClass::getJavaPsi).filter(PsiMethodUtil::hasMainMethod).limit(2L).toList();
        if (mainClassCandidates.size() == 1) {
            return mainClassCandidates.get(0);
        }
        return springBootClass;
    }

    public boolean isSpringBootApplicationRun(@NotNull PsiClass psiClass) {
        PsiMethod mainMethod;
        if (psiClass == null) {
            SpringBootApplicationServiceImpl.$$$reportNull$$$0(1);
        }
        if ((mainMethod = UastUtils.findMainInClass((UClass)((UClass)UastContextKt.toUElement((PsiElement)this.findMainClassCandidate(psiClass), UClass.class)))) == null) {
            return false;
        }
        return this.isSpringApplication(psiClass) || this.hasSpringBootApplicationRun(mainMethod);
    }

    public boolean hasSpringBootApplicationRun(@NotNull PsiMethod psiMethod) {
        UElement uElement;
        if (psiMethod == null) {
            SpringBootApplicationServiceImpl.$$$reportNull$$$0(2);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)psiMethod)) == null) {
            return false;
        }
        PsiElement sourcePsiElement = uElement.getSourcePsi();
        if (sourcePsiElement == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)sourcePsiElement, () -> {
            Ref result = new Ref((Object)false);
            PsiTreeUtil.processElements((PsiElement)sourcePsiElement, psiElement -> {
                UCallExpression expression = (UCallExpression)UastContextKt.toUElement((PsiElement)psiElement, UCallExpression.class);
                if (expression == null) {
                    return true;
                }
                if (RUN_METHOD_PATTERN.accepts((Object)expression)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            });
            PsiFile psiFile = sourcePsiElement.getContainingFile();
            PsiFile dependency = psiFile != null ? psiFile : PsiModificationTracker.getInstance((Project)sourcePsiElement.getProject());
            return new CachedValueProvider.Result((Object)((Boolean)result.get()), new Object[]{dependency, JavaLibraryModificationTracker.getInstance((Project)sourcePsiElement.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/SpringBootApplicationServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringBootApplicationRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringBootApplicationRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

