/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.jam.JamService;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKetPathBeanPropertyResolver;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyReferenceSearcher;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootConfigurationPropertyReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    private static final CachedValueProvider.Result<String> NULL_PREFIX_RESULT = CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});

    public SpringBootConfigurationPropertyReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        SearchScope scope;
        if (queryParameters == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((scope = queryParameters.getEffectiveSearchScope()) instanceof GlobalSearchScope)) {
            return;
        }
        Project project = queryParameters.getProject();
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return;
        }
        PsiMethod psiMethod = queryParameters.getMethod();
        String prefix = SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, true);
        if (prefix == null) {
            return;
        }
        if (GlobalSearchScope.EMPTY_SCOPE.equals(scope)) {
            scope = ProjectScope.getProjectScope((Project)project);
        }
        List<MetaConfigKey> metaConfigKeys = SpringBootConfigurationPropertyReferenceSearcher.findMetaConfigKeys(prefix, psiMethod);
        for (MetaConfigKey metaConfigKey : metaConfigKeys) {
            PsiElement keyDeclaration = metaConfigKey.getDeclaration();
            SearchRequestCollector requestCollector = new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession());
            queryParameters.getOptimizer().searchQuery(new QuerySearchRequest(ReferencesSearch.search((PsiElement)keyDeclaration, (SearchScope)scope), requestCollector, true, (reference, p) -> consumer.process(reference)));
        }
    }

    private static List<MetaConfigKey> findMetaConfigKeys(String prefix, PsiMethod psiMethod) {
        SmartList result = new SmartList();
        Module currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        if (currentModule != null) {
            result.addAll(SpringBootConfigurationPropertyReferenceSearcher.findMetaConfigKeysInModule(currentModule, prefix, psiMethod));
            return result;
        }
        for (Module module : SpringBootConfigKeyReferenceSearcher.getRelevantModules(psiMethod.getProject(), null)) {
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) continue;
            result.addAll(SpringBootConfigurationPropertyReferenceSearcher.findMetaConfigKeysInModule(module, prefix, psiMethod));
        }
        return result;
    }

    private static List<MetaConfigKey> findMetaConfigKeysInModule(Module module, String prefix, PsiMethod psiMethod) {
        SmartList result = new SmartList();
        boolean constructorBinding = psiMethod.isConstructor();
        for (MetaConfigKey key : SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module)) {
            if (key.getDeclarationResolveResult() != MetaConfigKey.DeclarationResolveResult.PROPERTY || !StringUtil.startsWith((CharSequence)key.getName(), (CharSequence)prefix)) continue;
            PsiElement declaration = key.getDeclaration().getNavigationElement();
            if (declaration instanceof PsiMethod) {
                if (constructorBinding || !psiMethod.getManager().areElementsEquivalent(declaration, (PsiElement)psiMethod)) continue;
                result.add(key);
                return result;
            }
            if (!(declaration instanceof PsiParameter) || !constructorBinding) continue;
            PsiManager psiManager = psiMethod.getManager();
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!psiManager.areElementsEquivalent(declaration, (PsiElement)psiParameter)) continue;
                result.add(key);
            }
        }
        return result;
    }

    @Nullable
    public static String getPrefixIfRelevantPropertyMethod(PsiMethod psiMethod, boolean checkIfBinder) {
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract")) {
            return null;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (checkIfBinder) {
            boolean isConstructor = psiMethod.isConstructor();
            if (!isConstructor && !PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
                return null;
            }
            Module currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
            PsiMethod bindingConstructor = SpringBootConfigKetPathBeanPropertyResolver.getBindingConstructor(containingClass, currentModule, null);
            if (isConstructor ? !psiMethod.getManager().areElementsEquivalent((PsiElement)bindingConstructor, (PsiElement)psiMethod) : bindingConstructor != null) {
                return null;
            }
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            if (containingClass.isInterface() || containingClass.hasModifierProperty("abstract") || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)containingClass)) {
                return NULL_PREFIX_RESULT;
            }
            ConfigurationProperties configurationProperties = SpringBootConfigurationPropertyReferenceSearcher.findEnclosingOrUsingConfigurationProperties(containingClass);
            if (configurationProperties == null) {
                return NULL_PREFIX_RESULT;
            }
            String prefix = configurationProperties.getValueOrPrefix();
            return CachedValueProvider.Result.create((Object)(prefix != null ? prefix : ""), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static ConfigurationProperties findEnclosingOrUsingConfigurationProperties(@NotNull PsiClass psiClass) {
        ConfigurationProperties currentClass;
        if (psiClass == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(2);
        }
        if ((currentClass = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass)) != null) {
            return currentClass;
        }
        if (psiClass.getContainingClass() != null) {
            return (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass.getContainingClass());
        }
        SearchScope classUseScope = psiClass.getUseScope();
        if (!(classUseScope instanceof GlobalSearchScope)) {
            return null;
        }
        GlobalSearchScope searchScope = (GlobalSearchScope)classUseScope;
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        List nestedConfigurationProperties = jamService.getJamFieldElements(NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", searchScope);
        for (NestedConfigurationProperty property : nestedConfigurationProperties) {
            if (!property.typeMatches(psiClass)) continue;
            return property.getEnclosingConfigurationProperties();
        }
        List beanConfigurationProperties = jamService.getJamMethodElements(ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", searchScope);
        for (ConfigurationProperties.Method configurationProperties : beanConfigurationProperties) {
            if (!configurationProperties.isDefinitionFor(psiClass)) continue;
            return configurationProperties;
        }
        return SpringBootConfigurationPropertyReferenceSearcher.findConfigurationPropertiesByClass(psiClass, searchScope);
    }

    @Nullable
    private static ConfigurationProperties findConfigurationPropertiesByClass(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope useScope) {
        PsiClass annoClass;
        if (psiClass == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (useScope == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(4);
        }
        if ((annoClass = SpringBootConfigurationPropertyReferenceSearcher.getConfigurationPropertiesAnnoClass((PsiElement)psiClass)) == null) {
            return null;
        }
        PsiMember annotatedMember = (PsiMember)AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)useScope).filtering(psiMember -> {
            PsiClass configClass = SpringBootConfigurationPropertyReferenceSearcher.getConfigPsiClass(psiMember);
            if (configClass == null) {
                return false;
            }
            return ContainerUtil.exists((Object[])configClass.getAllFields(), psiField -> SpringBootConfigurationPropertyReferenceSearcher.isMatchingConfigType(psiField, psiClass));
        }).findFirst();
        return ConfigurationProperties.getByPsiMember(annotatedMember);
    }

    @Nullable
    private static PsiClass getConfigurationPropertiesAnnoClass(@NotNull PsiElement psiElement) {
        Module module;
        if (psiElement == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) == null) {
            return null;
        }
        GlobalSearchScope annoSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
        return JavaPsiFacade.getInstance((Project)psiElement.getProject()).findClass("org.springframework.boot.context.properties.ConfigurationProperties", annoSearchScope);
    }

    @Nullable
    private static PsiClass getConfigPsiClass(@NotNull PsiMember psiMember) {
        PsiMethod configProducerMethod;
        PsiType methodReturnType;
        if (psiMember == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (psiMember instanceof PsiClass) {
            return (PsiClass)psiMember;
        }
        if (psiMember instanceof PsiMethod && (methodReturnType = (configProducerMethod = (PsiMethod)psiMember).getReturnType()) instanceof PsiClassReferenceType) {
            PsiClassReferenceType psiClassReferenceType = (PsiClassReferenceType)methodReturnType;
            return psiClassReferenceType.resolve();
        }
        return null;
    }

    private static boolean isMatchingConfigType(@NotNull PsiField psiField, @NotNull PsiClass psiClass) {
        if (psiField == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(8);
        }
        if (psiField.hasModifier(JvmModifier.STATIC)) {
            return false;
        }
        PsiType fieldType = psiField.getType();
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)fieldType);
        if (psiClass.isEquivalentTo((PsiElement)fieldClass)) {
            return true;
        }
        if (fieldType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)fieldType;
            return ContainerUtil.exists((Object[])psiClassType.getParameters(), parameterType -> {
                PsiClass parameterClass = PsiTypesUtil.getPsiClass((PsiType)parameterType);
                return psiClass.isEquivalentTo((PsiElement)parameterClass);
            });
        }
        if (fieldType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)fieldType;
            return psiClass.isEquivalentTo((PsiElement)PsiTypesUtil.getPsiClass((PsiType)psiArrayType.getComponentType()));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingOrUsingConfigurationProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findConfigurationPropertiesByClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationPropertiesAnnoClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigPsiClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatchingConfigType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

