/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.config.SpringBootConfigUnresolvedClassReferenceFixesProvider;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenStorage;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesDeprecationFix;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public abstract class SpringBootApplicationPropertiesInspectionBase
extends LocalInspectionTool {
    @NonNls
    public String replacementTokens = "@";
    @VisibleForTesting
    public final SpringBootReplacementTokenStorage myReplacementTokenStorage = new SpringBootReplacementTokenStorage();

    public SpringBootApplicationPropertiesInspectionBase() {
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public List<Couple<String>> getReplacementTokens() {
        return this.myReplacementTokenStorage.getReplacementTokens();
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringCommonUtils.isSpringConfigured((Project)manager.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = this.getModule(file);
        if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        for (IProperty iProperty : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            PsiReference[] keyParts;
            PropertyImpl property;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(iProperty instanceof PropertyImpl) || (propertyKey = SpringBootApplicationPropertiesUtil.getPropertyKey(property = (PropertyImpl)iProperty)) == null) continue;
            MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
            if (configKey == null) {
                String keyName = property.getName();
                configFileHighlightingUtil.highlightUnresolvedConfigKey((PsiElement)propertyKey, (PsiElement)property, keyName, isOnTheFly);
                continue;
            }
            if (configKey.getDeprecation() != MetaConfigKey.Deprecation.NOT_DEPRECATED) {
                configFileHighlightingUtil.highlightDeprecatedConfigKey((PsiElement)propertyKey, configKey, SpringBootApplicationPropertiesInspectionBase.getDeprecationFix(property, configKey));
            }
            if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP) && ((keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)propertyKey.getText(), (boolean)false)) == null || keyParts.getKeyIndex() == null)) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message((String)"application.config.missing.map.key", (Object[])new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            SpringBootApplicationPropertiesInspectionBase.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                keyParts = propertyKey.getReferences();
                int n = keyParts.length;
                for (int i = 0; i < n; ++i) {
                    PsiReference reference = keyParts[i];
                    if (!(reference instanceof ConfigKeyPathReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if ((valueElement = SpringBootApplicationPropertiesUtil.getPropertyValue(property)) == null) continue;
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)valueElement, (ProblemsHolder)holder, arg_0 -> ((SpringBootConfigUnresolvedClassReferenceFixesProvider.Companion)SpringBootConfigUnresolvedClassReferenceFixesProvider.Companion).getAllFixes(arg_0));
        }
        return holder.getResultsArray();
    }

    @Nullable
    protected Module getModule(@NotNull PsiFile file) {
        if (file == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(2);
        }
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
    }

    private static void highlightIndexAccessExpressions(final ProblemsHolder holder, final PropertyKeyImpl propertyKey, MetaConfigKey configKey) {
        new IndexAccessTextProcessor(propertyKey.getText(), configKey){

            protected void onMissingClosingBracket(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message((String)"application.config.missing.closing.bracket", (Object[])new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            protected void onMissingIndexValue(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message((String)"application.config.missing.index.value", (Object[])new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            protected void onBracket(int startIdx) {
            }

            protected void onIndexValue(TextRange indexValueRange) {
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message((String)"application.config.non.integer.index", (Object[])new Object[0]), ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
        }.process();
    }

    private static LocalQuickFix[] getDeprecationFix(PropertyImpl property, MetaConfigKey configKey) {
        String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new SpringBootApplicationPropertiesDeprecationFix((PsiElement)property, replacement, configKey)};
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(4);
        }
        this.replacementTokens = this.myReplacementTokenStorage.serialize();
        super.writeSettings(element);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"myReplacementTokenStorage", (String)SpringBootApiBundle.message((String)"spring.boot.replacement.token.label", (Object[])new Object[0]))});
        if (optPane == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(5);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("myReplacementTokenStorage", () -> ((SpringBootReplacementTokenStorage)this.myReplacementTokenStorage).getTokens());
        if (optionController == null) {
            SpringBootApplicationPropertiesInspectionBase.$$$reportNull$$$0(6);
        }
        return optionController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

