/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpringBootApplicationPropertiesUtil {
    private static final String HASH_SEPARATOR = "#---";
    private static final String EXCLAMATION_SEPARATOR = "!---";
    static final Set<String> SEPARATORS = Set.of("#---", "!---");
    private static final Set<String> SEPARATORS_2_4 = Set.of("#---");

    @Nullable
    static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    static boolean isSupportMultiDocuments(@Nullable Module module) {
        return !SpringBootApplicationPropertiesUtil.getDocumentSeparators(module).isEmpty();
    }

    @NotNull
    static Set<String> getDocumentSeparators(@Nullable Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
            Set<String> set = SEPARATORS;
            if (set == null) {
                SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(0);
            }
            return set;
        }
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_4_0)) {
            Set<String> set = SEPARATORS_2_4;
            if (set == null) {
                SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(2);
        }
        return set;
    }

    public static List<IProperty> getDocument(@NotNull Property anchor, @Nullable Module module) {
        Set<String> separators;
        if (anchor == null) {
            SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(3);
        }
        if ((separators = SpringBootApplicationPropertiesUtil.getDocumentSeparators(module)).isEmpty()) {
            return anchor.getPropertiesFile().getProperties();
        }
        SmartList result = new SmartList();
        SmartList before = new SmartList();
        PsiElement element = anchor.getPrevSibling();
        while (element != null) {
            PsiElement prev = element.getPrevSibling();
            if (element instanceof Property) {
                before.add((Property)element);
            } else if (prev == null || SpringBootApplicationPropertiesUtil.isDocumentSeparator(element, prev, separators)) break;
            element = prev;
        }
        result.addAll(ContainerUtil.reverse((List)before));
        SpringBootApplicationPropertiesUtil.collectDocument(anchor, (List<IProperty>)result, separators);
        return result;
    }

    static List<List<IProperty>> getDocuments(@NotNull PropertiesFile file, Set<String> separators) {
        if (file == null) {
            SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(4);
        }
        return (List)AstLoadingFilter.forceAllowTreeLoading((PsiFile)((PsiFile)file), () -> {
            if (separators.isEmpty()) {
                return new SmartList((Object)file.getProperties());
            }
            Property property = (Property)ContainerUtil.getFirstItem((List)file.getProperties());
            if (property == null) {
                return Collections.emptyList();
            }
            SmartList result = new SmartList();
            while (property != null) {
                SmartList document = new SmartList();
                property = SpringBootApplicationPropertiesUtil.collectDocument(property, (List<IProperty>)document, separators);
                result.add(document);
            }
            return result;
        });
    }

    public static List<List<IProperty>> getDocuments(@NotNull PropertiesFile file, @Nullable Module module) {
        if (file == null) {
            SpringBootApplicationPropertiesUtil.$$$reportNull$$$0(5);
        }
        Set<String> separators = SpringBootApplicationPropertiesUtil.getDocumentSeparators(module);
        return SpringBootApplicationPropertiesUtil.getDocuments(file, separators);
    }

    private static Property collectDocument(Property property, List<IProperty> document, Set<String> separators) {
        document.add((IProperty)property);
        Property current = property;
        PsiElement next = current.getNextSibling();
        while (next != null) {
            if (next instanceof Property) {
                document.add((IProperty)((Property)next));
            } else if (SpringBootApplicationPropertiesUtil.isDocumentSeparator(next, (PsiElement)current, separators)) break;
            current = next;
            next = current.getNextSibling();
        }
        while (next != null) {
            if (!((next = next.getNextSibling()) instanceof Property)) continue;
            return (Property)next;
        }
        return null;
    }

    private static boolean isDocumentSeparator(PsiElement candidate, PsiElement prevSibling, Set<String> separators) {
        return candidate instanceof PsiComment && separators.contains(candidate.getText().trim()) && StringUtil.convertLineSeparators((String)prevSibling.getText()).endsWith("\n") && SpringBootApplicationPropertiesUtil.isNotNextToComment(candidate, prevSibling);
    }

    private static boolean isNotNextToComment(PsiElement candidate, PsiElement prevSibling) {
        if (prevSibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)StringUtil.convertLineSeparators((String)prevSibling.getText())) == 1 && prevSibling.getPrevSibling() instanceof PsiComment) {
            return false;
        }
        PsiElement nextSibling = candidate.getNextSibling();
        return !(nextSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)StringUtil.convertLineSeparators((String)nextSibling.getText())) != 1 || !(nextSibling.getNextSibling() instanceof PsiComment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentSeparators";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocuments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

