/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootPropertiesFileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootPropertiesScanner {
    private final MetaConfigKeyManager.ConfigKeyNameBinder keyNameBinder;

    public SpringBootPropertiesScanner(@NotNull MetaConfigKeyManager.ConfigKeyNameBinder binder) {
        if (binder == null) {
            SpringBootPropertiesScanner.$$$reportNull$$$0(0);
        }
        this.keyNameBinder = binder;
    }

    List<Pair<String, Integer>> collectImports(@NotNull PsiFile propertiesFile) {
        if (propertiesFile == null) {
            SpringBootPropertiesScanner.$$$reportNull$$$0(1);
        }
        SmartList results = new SmartList();
        Project project = propertiesFile.getProject();
        MetaConfigKey configKey = SpringBootApplicationMetaConfigKeyManager.getInstance().createFakeConfigKey(project, "spring.config.import", MetaConfigKey.AccessType.INDEXED);
        List documents = SpringBootPropertiesFileUtil.getInstance().getDocuments(propertiesFile);
        if (!documents.isEmpty()) {
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                MicroservicePropertiesDocument document = (MicroservicePropertiesDocument)documents.get(documentId);
                this.processDocument(document, documentId, null, configKey, null, null, true, arg_0 -> SpringBootPropertiesScanner.lambda$collectImports$0((List)results, arg_0));
            }
        }
        return results;
    }

    boolean processDocument(MicroservicePropertiesDocument document, int documentId, @Nullable String profileText, ConfigurationValueSearchParams params, Consumer<ConfigurationValueResult> results) {
        return this.processDocument(document, documentId, profileText, params.getConfigKey(), params.getKeyIndex(), params.getKeyProperty(), params.getCheckRelaxedNames(), results);
    }

    private boolean processDocument(MicroservicePropertiesDocument document, int documentId, @Nullable String profileText, MetaConfigKey configKey, String keyIndex, String keyProperty, boolean checkRelaxedNames, Consumer<ConfigurationValueResult> results) {
        boolean multipleOccurrencesPossible;
        String keyName = configKey.getName();
        List reversed = ContainerUtil.reverse((List)document.getProperties());
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL, MetaConfigKey.AccessType.INDEXED})) {
            IProperty byExactName = null;
            for (IProperty property : reversed) {
                if (!keyName.equals(property.getKey())) continue;
                byExactName = property;
                break;
            }
            if (byExactName != null) {
                results.accept(SpringBootPropertiesScanner.createResult(configKey, profileText, byExactName, null, documentId));
                return false;
            }
            if (!checkRelaxedNames && configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
                return true;
            }
        }
        boolean processParts = (multipleOccurrencesPossible = configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.ENUM_MAP, MetaConfigKey.AccessType.MAP, MetaConfigKey.AccessType.INDEXED})) && (keyIndex != null || keyProperty != null);
        boolean found = false;
        for (IProperty property : reversed) {
            ProgressManager.checkCanceled();
            String propertyName = property.getName();
            if (propertyName == null || !checkRelaxedNames && !propertyName.startsWith(keyName)) continue;
            if (processParts) {
                String keyIndexText = this.keyNameBinder.bindsToKeyProperty(configKey, keyProperty, propertyName);
                if (keyIndexText == null || !StringUtil.isEmpty((String)keyIndex) && !keyIndexText.equals(keyIndex)) continue;
                results.accept(SpringBootPropertiesScanner.createResult(configKey, profileText, property, keyIndexText, documentId));
                found = true;
                continue;
            }
            if (!this.keyNameBinder.bindsTo(configKey, propertyName)) continue;
            results.accept(SpringBootPropertiesScanner.createResult(configKey, profileText, property, null, documentId));
            if (!multipleOccurrencesPossible) {
                return false;
            }
            found = true;
        }
        return !found;
    }

    @NotNull
    private static ConfigurationValueResult createResult(@NotNull MetaConfigKey configKey, @Nullable String profileText, @NotNull IProperty property, @Nullable String keyIndexText, int documentId) {
        if (configKey == null) {
            SpringBootPropertiesScanner.$$$reportNull$$$0(2);
        }
        if (property == null) {
            SpringBootPropertiesScanner.$$$reportNull$$$0(3);
        }
        PropertyImpl propertyImpl = (PropertyImpl)property.getPsiElement();
        PropertyKeyImpl key = SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl);
        assert (key != null);
        return new ConfigurationValueResult((PsiElement)key, keyIndexText, (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), propertyImpl.getValue(), documentId, configKey, profileText);
    }

    private static /* synthetic */ void lambda$collectImports$0(List results, ConfigurationValueResult item) {
        results.add(new Pair((Object)item.getValueText(), (Object)item.getDocumentId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootPropertiesScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImports";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

