/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class SpringBootBannerAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootBannerAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootBannerAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiPlainTextFile)) {
            return;
        }
        if (!SpringBootBannerReferenceContributor.Holder.PATTERN.accepts((Object)element)) {
            return;
        }
        for (PsiReference reference : element.getReferences()) {
            TextRange referenceTextRange = reference.getRangeInElement().shiftRight(element.getTextOffset());
            if (SpringBootBannerAnnotator.hasUnresolvedReference(reference)) {
                holder.newAnnotation(HighlightSeverity.WARNING, SpringBootApiBundle.message((String)"banner.unresolved.property", (Object[])new Object[]{reference.getCanonicalText()})).range(referenceTextRange).highlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING).create();
                continue;
            }
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(referenceTextRange).textAttributes(PropertiesHighlighter.PropertiesComponent.PROPERTY_KEY.getTextAttributesKey()).create();
        }
    }

    private static boolean hasUnresolvedReference(PsiReference reference) {
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            return results.length == 0;
        }
        return reference.resolve() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/banner/SpringBootBannerAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

