/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.facet.SpringBootCustomizationDialog;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jdom.Attribute;
import org.jetbrains.annotations.NotNull;

public final class SpringBootFileSetEditorCustomization
extends SpringFileSetEditorCustomization {
    public static final Key<CustomSetting.BOOLEAN> NON_STRICT_SETTING = Key.create((String)"spring_boot_non_strict_conditional_eval");

    public SpringBootFileSetEditorCustomization() {
        SpringBootModelConfigFileNameContributor.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SpringBootModelConfigFileNameContributor>(this){

            public void extensionAdded(@NotNull SpringBootModelConfigFileNameContributor contributor, @NotNull PluginDescriptor pluginDescriptor) {
                if (contributor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                1.forEachSpringFacet(facet -> {
                    Set customSettings = ((SpringFacetConfiguration)facet.getConfiguration()).getCustomSettings();
                    boolean modified = customSettings.add(contributor.getCustomNameSettingDescriptor().createCustomSetting());
                    boolean bl = modified = customSettings.add(contributor.getCustomFilesSettingDescriptor().createCustomSetting()) || modified;
                    if (modified) {
                        1.setModified(facet);
                    }
                });
            }

            private static void forEachSpringFacet(Consumer<SpringFacet> consumer) {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        SpringFacet facet = SpringFacet.getInstance((Module)module);
                        if (facet == null) continue;
                        consumer.accept(facet);
                    }
                }
            }

            private static void setModified(SpringFacet facet) {
                ((SpringFacetConfiguration)facet.getConfiguration()).setModified();
                FacetManager.getInstance((Module)facet.getModule()).facetConfigurationChanged((Facet)facet);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contributor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/facet/SpringBootFileSetEditorCustomization$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    public boolean isApplicable(SpringFileSet fileSet) {
        return ContainerUtil.exists((Object[])((SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()), contributor -> contributor.accept(fileSet));
    }

    public List<SpringFileSetEditorCustomization.CustomConfigFileGroup> getCustomConfigFileGroups(SpringFileSet fileSet) {
        Module module = fileSet.getFacet().getModule();
        List files = SpringBootConfigurationFileService.getInstance().findConfigFiles(module, false, contributor -> contributor.accept(fileSet));
        HashSet allContributorFiles = new HashSet(files);
        allContributorFiles.addAll(SpringBootConfigurationFileService.getInstance().collectImports(module, files));
        LinkedHashSet<VirtualFilePointer> configFiles = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer pointer : fileSet.getFiles()) {
            VirtualFile file;
            if (!pointer.isValid() || (file = pointer.getFile()) == null || !allContributorFiles.contains(file)) continue;
            configFiles.add(pointer);
        }
        if (configFiles.isEmpty()) {
            return Collections.emptyList();
        }
        Icon configFileGroupIcon = SpringBootApiIcons.SpringBoot;
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(fileSet)) continue;
            configFileGroupIcon = fileNameContributor.getFileIcon();
            break;
        }
        return Collections.singletonList(new SpringFileSetEditorCustomization.CustomConfigFileGroup("Configuration Files", configFileGroupIcon, configFiles));
    }

    public List<CustomSetting> getCustomSettings() {
        SmartList customSettings = new SmartList((Object)new CustomSetting.BOOLEAN(NON_STRICT_SETTING, SpringBootApiBundle.message((String)"spring.boot.non-strict.conditional.evaluation", (Object[])new Object[0]), true));
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            customSettings.add(fileNameContributor.getCustomNameSettingDescriptor().createCustomSetting());
            customSettings.add(fileNameContributor.getCustomFilesSettingDescriptor().createCustomSetting());
        }
        return customSettings;
    }

    public AnAction[] getExtraActions() {
        return new AnAction[]{new CustomizeSpringBootAction()};
    }

    private static final class CustomizeSpringBootAction
    extends AnAction {
        private CustomizeSpringBootAction() {
            super(SpringBootApiBundle.message((String)"spring.boot.customization.action.name", (Object[])new Object[0]), SpringBootApiBundle.message((String)"spring.boot.customization.action.description", (Object[])new Object[0]), SpringBootApiIcons.SpringBoot);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SpringFileSet fileSet;
            if (e == null) {
                CustomizeSpringBootAction.$$$reportNull$$$0(0);
            }
            if ((fileSet = (SpringFileSet)DataManager.getInstance().loadFromDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET)) == null) {
                return;
            }
            for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
                if (!fileNameContributor.accept(fileSet)) continue;
                SpringBootCustomizationDialog customizationDialog = new SpringBootCustomizationDialog(e.getProject(), fileSet, fileNameContributor);
                customizationDialog.show();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/facet/SpringBootFileSetEditorCustomization$CustomizeSpringBootAction", "actionPerformed"));
        }
    }

    static class SpringBootCustomConfigFilesSettingPathMacroFilter
    extends PathMacroFilter {
        SpringBootCustomConfigFilesSettingPathMacroFilter() {
        }

        public boolean recursePathMacros(@NotNull Attribute attribute) {
            if (attribute == null) {
                SpringBootCustomConfigFilesSettingPathMacroFilter.$$$reportNull$$$0(0);
            }
            if (!"configuration".equals(attribute.getParent().getName())) {
                return false;
            }
            for (SpringBootModelConfigFileNameContributor c : SpringBootModelConfigFileNameContributor.EP_NAME.getExtensionList()) {
                if (!c.getCustomFilesSettingDescriptor().key.toString().equals(attribute.getName())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/spring/boot/facet/SpringBootFileSetEditorCustomization$SpringBootCustomConfigFilesSettingPathMacroFilter", "recursePathMacros"));
        }
    }
}

