/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassSorter;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndex;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndexKt;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoConfigClassFilterService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.ArrayList;
import java.util.List;

class SpringBootAutoConfigClassFilterServiceImpl
extends SpringBootAutoConfigClassFilterService {
    SpringBootAutoConfigClassFilterServiceImpl() {
    }

    public List<PsiClass> filterByConditionalOnClass(Module module, List<PsiClass> configs) {
        GlobalSearchScope searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)module.getProject());
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        ArrayList<PsiClass> enabled = new ArrayList<PsiClass>(configs.size() / 2);
        for (PsiClass config : configs) {
            AutoConfigureMetadataIndex.AutoConfigureMetadata metadata = AutoConfigureMetadataIndexKt.findAutoConfigureMetadata(config);
            if (metadata != null) {
                boolean foundAll = true;
                if (SpringBootAutoConfigClassFilterServiceImpl.isFromScope(config, librariesScope)) {
                    for (String conditionalClass : metadata.getConditionalOnClass()) {
                        aClass = SpringCommonUtils.findLibraryClass((Module)module, (String)conditionalClass);
                        if (aClass != null) continue;
                        foundAll = false;
                        break;
                    }
                } else {
                    for (String conditionalClass : metadata.getConditionalOnClass()) {
                        aClass = javaPsiFacade.findClass(conditionalClass, searchScope);
                        if (aClass != null) continue;
                        foundAll = false;
                        break;
                    }
                }
                if (!foundAll) continue;
                enabled.add(config);
                continue;
            }
            if (!AutoConfigClassSorter.passesConditionalClassMatch(config)) continue;
            enabled.add(config);
        }
        return enabled;
    }

    private static boolean isFromScope(PsiClass psiClass, GlobalSearchScope librariesScope) {
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        return librariesScope.contains(file);
    }
}

