/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.autoconfigure.AbstractAutoConfigDependentModelsProvider;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigMethodConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.model.ConditionalEvaluationContext;
import com.intellij.spring.model.ConditionalEvaluator;
import com.intellij.spring.model.ConditionalEvaluatorProvider;
import com.intellij.spring.model.SpringBeanPointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public class SpringBootConditionalEvaluatorProvider
implements ConditionalEvaluatorProvider {
    @Nullable
    public ConditionalEvaluator getConditionalEvaluator(@NotNull SpringBeanPointer<?> pointer) {
        PsiElement psiElement;
        if (pointer == null) {
            SpringBootConditionalEvaluatorProvider.$$$reportNull$$$0(0);
        }
        if ((psiElement = pointer.getPsiElement()) == null) {
            return null;
        }
        if (psiElement instanceof PsiMethod) {
            return SpringBootConditionalEvaluatorProvider.getMethodConditionalEvaluator((PsiMethod)psiElement);
        }
        if (psiElement instanceof PsiClass) {
            return SpringBootConditionalEvaluatorProvider.getClassConditionalEvaluator((PsiClass)psiElement);
        }
        PsiElement navigationElement = psiElement.getNavigationElement();
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)navigationElement, UClass.class);
        if (uClass == null) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        return SpringBootConditionalEvaluatorProvider.getClassConditionalEvaluator(psiClass);
    }

    private static ConditionalEvaluator getMethodConditionalEvaluator(final PsiMethod psiMethod) {
        if (!SpringBootConditionalEvaluatorProvider.hasConditionals((PsiElement)psiMethod)) {
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            return SpringBootConditionalEvaluatorProvider.getClassConditionalEvaluator(psiClass);
        }
        return new ConditionalEvaluator(){

            public boolean isActive(@NotNull ConditionalEvaluationContext context) {
                CommonSpringModel model;
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((model = context.getModel()) == null) {
                    return false;
                }
                Module module = model.getModule();
                if (module == null) {
                    return false;
                }
                PsiClass psiClass = psiMethod.getContainingClass();
                if (psiClass == null) {
                    return false;
                }
                NotNullLazyValue<List<VirtualFile>> configFilesCache = AbstractAutoConfigDependentModelsProvider.createConfigFilesCache(module, model.getActiveProfiles());
                ConditionalOnEvaluationContextBase sharedContext = new ConditionalOnEvaluationContextBase(psiClass, module, model.getActiveProfiles(), configFilesCache, null);
                AutoConfigMethodConditionEvaluator evaluator = new AutoConfigMethodConditionEvaluator(psiMethod, false, (ConditionalOnEvaluationContext)sharedContext);
                sharedContext.putUserData(ConditionalOnEvaluationContext.MODEL_KEY, (Object)model);
                if (!evaluator.isActive()) {
                    return false;
                }
                AutoConfigClassConditionEvaluator classEvaluator = new AutoConfigClassConditionEvaluator(psiClass, false, (ConditionalOnEvaluationContext)sharedContext);
                return classEvaluator.isActive();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/model/autoconfigure/SpringBootConditionalEvaluatorProvider$1", "isActive"));
            }
        };
    }

    private static ConditionalEvaluator getClassConditionalEvaluator(final PsiClass psiClass) {
        if (!SpringBootConditionalEvaluatorProvider.hasConditionals((PsiElement)psiClass)) {
            return null;
        }
        return new ConditionalEvaluator(){

            public boolean isActive(@NotNull ConditionalEvaluationContext context) {
                CommonSpringModel model;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((model = context.getModel()) == null) {
                    return false;
                }
                Module module = model.getModule();
                if (module == null) {
                    return false;
                }
                NotNullLazyValue<List<VirtualFile>> configFilesCache = AbstractAutoConfigDependentModelsProvider.createConfigFilesCache(module, model.getActiveProfiles());
                ConditionalOnEvaluationContextBase sharedContext = new ConditionalOnEvaluationContextBase(psiClass, module, model.getActiveProfiles(), configFilesCache, null);
                AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(psiClass, false, (ConditionalOnEvaluationContext)sharedContext);
                sharedContext.putUserData(ConditionalOnEvaluationContext.MODEL_KEY, (Object)model);
                return evaluator.isActive();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/model/autoconfigure/SpringBootConditionalEvaluatorProvider$2", "isActive"));
            }
        };
    }

    private static boolean hasConditionals(PsiElement psiElement) {
        return JamService.getJamService((Project)psiElement.getProject()).getJamElement(ConditionalOnJamElement.CONDITIONAL_JAM_ELEMENT_KEY, psiElement) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/boot/model/autoconfigure/SpringBootConditionalEvaluatorProvider", "getConditionalEvaluator"));
    }
}

