/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.actuator;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.AbstractAutoConfigDependentModelsProvider;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoConfigClassFilterService;
import com.intellij.spring.boot.model.autoconfigure.SpringOrderClassSorter;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagementContextConfigurationDependentModelsProvider
extends AbstractAutoConfigDependentModelsProvider {
    @Override
    protected List<PsiClass> getAutoConfigClasses(@NotNull LocalAnnotationModel localAnnotationModel, @NotNull ConditionalOnEvaluationContext sharedContext) {
        Module module;
        if (localAnnotationModel == null) {
            ManagementContextConfigurationDependentModelsProvider.$$$reportNull$$$0(0);
        }
        if (sharedContext == null) {
            ManagementContextConfigurationDependentModelsProvider.$$$reportNull$$$0(1);
        }
        if ((module = sharedContext.getModule()).isDisposed()) {
            return Collections.emptyList();
        }
        String key = ManagementContextConfigurationDependentModelsProvider.getManagementContextConfigurationClass(localAnnotationModel.getConfig());
        if (key == null) {
            return Collections.emptyList();
        }
        List<PsiClass> contextConfigs = ManagementContextConfigurationDependentModelsProvider.getAllRegisteredManagementContextConfigurationClasses(module, key);
        List filteredConfigs = SpringBootAutoConfigClassFilterService.getInstance().filterByConditionalOnClass(module, contextConfigs);
        SpringOrderClassSorter sorter = new SpringOrderClassSorter(filteredConfigs);
        return sorter.getSortedConfigs();
    }

    @Nullable
    private static String getManagementContextConfigurationClass(@NotNull PsiClass localModelConfigClass) {
        if (localModelConfigClass == null) {
            ManagementContextConfigurationDependentModelsProvider.$$$reportNull$$$0(2);
        }
        if ("org.springframework.boot.actuate.autoconfigure.ManagementContextConfigurationsImportSelector".equals(localModelConfigClass.getQualifiedName())) {
            return "org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration";
        }
        if ("org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextConfigurationImportSelector".equals(localModelConfigClass.getQualifiedName())) {
            return "org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration";
        }
        return null;
    }

    public static List<PsiClass> getAllRegisteredManagementContextConfigurationClasses(Module module, String key) {
        List contextConfigs = SpringSpiManager.getInstance((Project)module.getProject()).getClassesListValue(module, key, false);
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
            SpringBootImportsManager importsManager = SpringBootImportsManager.Companion.getInstance();
            contextConfigs.addAll(importsManager.getClasses(module, key, false));
        }
        ContainerUtil.removeDuplicates((Collection)contextConfigs);
        return contextConfigs;
    }

    @Override
    @NotNull
    protected LocalModelDependencyType getModelDependencyType() {
        LocalModelDependencyType localModelDependencyType = LocalModelDependencyType.IMPORT;
        if (localModelDependencyType == null) {
            ManagementContextConfigurationDependentModelsProvider.$$$reportNull$$$0(3);
        }
        return localModelDependencyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAnnotationModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModelConfigClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/actuator/ManagementContextConfigurationDependentModelsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/actuator/ManagementContextConfigurationDependentModelsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelDependencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfigClasses";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getManagementContextConfigurationClass";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

