/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import org.jetbrains.annotations.NonNls;

class MailSenderCondition
extends ConditionalContributor {
    @NonNls
    private static final String SPRING_MAIL_HOST = "spring.mail.host";
    @NonNls
    private static final String SPRING_MAIL_JNDI_NAME = "spring.mail.jndi-name";

    MailSenderCondition() {
    }

    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        if (this.hasConfigKey(context, SPRING_MAIL_HOST)) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.foundConfigKey((String)SPRING_MAIL_HOST));
        }
        if (this.hasConfigKey(context, SPRING_MAIL_JNDI_NAME)) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.foundConfigKey((String)SPRING_MAIL_JNDI_NAME));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.didNotFindConfigKey((String[])new String[]{SPRING_MAIL_HOST, SPRING_MAIL_JNDI_NAME}));
    }
}

