/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProvidersElementList;
import com.intellij.spi.psi.SPIPackageOrClassReferenceElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "ImportPackageOrClassReference", "intellij.spring.boot.core"})
public final class SpringBootImportsReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiReference[] psiReferenceArray = new PsiReference[]{new ImportPackageOrClassReference((SPIPackageOrClassReferenceElement)element)};
        return psiReferenceArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsReferenceProvider$ImportPackageOrClassReference;", "Lcom/intellij/psi/PsiReference;", "psiElement", "Lcom/intellij/spi/psi/SPIPackageOrClassReferenceElement;", "<init>", "(Lcom/intellij/spi/psi/SPIPackageOrClassReferenceElement;)V", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getCanonicalText", "", "handleElementRename", "newElementName", "resolve", "bindToElement", "element", "isReferenceTo", "", "isSoft", "intellij.spring.boot.core"})
    private static final class ImportPackageOrClassReference
    implements PsiReference {
        @NotNull
        private final SPIPackageOrClassReferenceElement psiElement;

        public ImportPackageOrClassReference(@NotNull SPIPackageOrClassReferenceElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            this.psiElement = psiElement;
        }

        @NotNull
        public PsiElement getElement() {
            return (PsiElement)this.psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            PsiElement psiElement = PsiTreeUtil.getDeepestLast((PsiElement)((PsiElement)this.psiElement));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDeepestLast(...)");
            PsiElement last = psiElement;
            return new TextRange(last.getStartOffsetInParent(), this.psiElement.getTextLength());
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.psiElement.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            return string;
        }

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            PsiElement psiElement = this.psiElement.handleElementRename(newElementName);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleElementRename(...)");
            return psiElement;
        }

        @Nullable
        public PsiElement resolve() {
            return this.psiElement.resolve();
        }

        @Nullable
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PsiPackage) {
                string = ((PsiPackage)element).getQualifiedName();
            } else if (element instanceof PsiClass) {
                String string2 = this.psiElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                string = StringsKt.contains$default((CharSequence)string2, (char)'$', (boolean)false, (int)2, null) ? ClassUtil.getJVMClassName((PsiClass)((PsiClass)element)) : ((PsiClass)element).getQualifiedName();
            } else {
                return null;
            }
            String newName = string;
            if (newName == null) {
                return null;
            }
            PsiElement psiElement = PsiFileFactory.getInstance((Project)this.psiElement.getProject()).createFileFromText("spi_dummy", (FileType)SPIFileType.INSTANCE, (CharSequence)newName).getFirstChild();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.spi.psi.SPIClassProvidersElementList");
            SPIClassProvidersElementList firstChild = (SPIClassProvidersElementList)psiElement;
            return this.psiElement.replace((PsiElement)firstChild.getElements().get(0));
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PsiPackage) {
                return Intrinsics.areEqual((Object)this.psiElement.getText(), (Object)((PsiPackage)element).getQualifiedName());
            }
            if (element instanceof PsiClass) {
                String text = this.psiElement.getText();
                return Intrinsics.areEqual((Object)text, (Object)((PsiClass)element).getQualifiedName()) || Intrinsics.areEqual((Object)text, (Object)ClassUtil.getJVMClassName((PsiClass)((PsiClass)element)));
            }
            return false;
        }

        public boolean isSoft() {
            return this.psiElement.isSoft();
        }
    }
}

