/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ui.icons.CacheKey;
import com.intellij.ui.icons.IconUtilKt;
import java.awt.image.BufferedImage;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/icons/ImageCache;", "", "<init>", "()V", "ioMissCache", "", "", "imageCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/ui/icons/CacheKey;", "Ljava/awt/image/BufferedImage;", "intellij.platform.util.ui"})
final class ImageCache {
    @NotNull
    public static final ImageCache INSTANCE = new ImageCache();
    @JvmField
    @NotNull
    public static final Set<String> ioMissCache;
    @JvmField
    @NotNull
    public static final Cache<CacheKey, BufferedImage> imageCache;

    private ImageCache() {
    }

    private static final int imageCache$lambda$0(CacheKey cacheKey, BufferedImage value) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return 4 * value.getWidth() * value.getHeight();
    }

    private static final Unit _init_$lambda$0() {
        imageCache.invalidateAll();
        ioMissCache.clear();
        return Unit.INSTANCE;
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        ioMissCache = keySetView;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).maximumWeight(0x2000000L).weigher(ImageCache::imageCache$lambda$0).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        imageCache = cache;
        IconUtilKt.registerIconCacheCleaner((Function0<Unit>)((Function0)ImageCache::_init_$lambda$0));
    }
}

