/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.icons.ImageDataByFilePathLoader;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u001c\u001a\u00020\u0003H\u0096\u0080\u0004J\u0014\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0082\u0004J\n\u0010 \u001a\u00020!H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/ui/icons/ImageDataByPathLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "original", "<init>", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lcom/intellij/ui/icons/ImageDataByPathLoader;)V", "getPath", "()Ljava/lang/String;", "getCoords", "Lkotlin/Pair;", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "patch", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isMyClassLoader", "", "toString", "equals", "other", "", "hashCode", "", "Companion", "intellij.platform.util.ui"})
public final class ImageDataByPathLoader
implements ImageDataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final ImageDataByPathLoader original;

    private ImageDataByPathLoader(String path, ClassLoader classLoader, ImageDataByPathLoader original) {
        this.path = path;
        this.classLoader = classLoader;
        this.original = original;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Pair<String, ClassLoader> getCoords() {
        return TuplesKt.to((Object)this.getPath(), (Object)this.classLoader);
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        String string = this.getPath();
        boolean bl = parameters.isDark;
        List<ImageFilter> list = parameters.filters;
        SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider = parameters.colorPatcher;
        ClassLoader classLoader = this.classLoader;
        boolean bl2 = parameters.isStroke;
        return ImageCacheKt.loadImage$default(string, null, classLoader, scaleContext, bl, svgElementColorPatcherProvider, list, bl2, false, 2, null);
    }

    @Override
    @Nullable
    public URL getUrl() {
        return this.classLoader.getResource(ImageDataByPathLoaderKt.normalizePath(this.getPath()));
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull IconTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        boolean isOriginal = this.original == null;
        return ImageDataByPathLoader.Companion.doPatch(isOriginal ? this : this.original, transform, isOriginal);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoader == classLoader || this.original != null && this.original.classLoader == classLoader;
    }

    @NotNull
    public String toString() {
        return "ImageDataByPathLoader(classLoader=" + this.classLoader + ", path=" + this.getPath() + ", original=" + this.original + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImageDataByPathLoader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPath(), (Object)((ImageDataByPathLoader)other).getPath())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classLoader, (Object)((ImageDataByPathLoader)other).classLoader)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.original, (Object)((ImageDataByPathLoader)other).original);
    }

    public int hashCode() {
        int result = this.getPath().hashCode();
        result = 31 * result + this.classLoader.hashCode();
        ImageDataByPathLoader imageDataByPathLoader = this.original;
        result = 31 * result + (imageDataByPathLoader != null ? imageDataByPathLoader.hashCode() : 0);
        return result;
    }

    public /* synthetic */ ImageDataByPathLoader(String path, ClassLoader classLoader, ImageDataByPathLoader original, DefaultConstructorMarker $constructor_marker) {
        this(path, classLoader, original);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J^\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0012\b\u0002\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/icons/ImageDataByPathLoader$Companion;", "", "<init>", "()V", "createIcon", "Lcom/intellij/ui/icons/CachedImageIcon;", "originalPath", "", "Lorg/jetbrains/annotations/NonNls;", "originalClassLoader", "Ljava/lang/ClassLoader;", "patched", "Lkotlin/Pair;", "path", "classLoader", "toolTip", "Ljava/util/function/Supplier;", "createIcon$intellij_platform_util_ui", "doPatch", "Lcom/intellij/ui/icons/ImageDataLoader;", "originalLoader", "Lcom/intellij/ui/icons/ImageDataByPathLoader;", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isOriginal", "", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CachedImageIcon createIcon$intellij_platform_util_ui(@NotNull String originalPath, @NotNull ClassLoader originalClassLoader, @Nullable Pair<String, ? extends ClassLoader> patched, @NotNull String path, @NotNull ClassLoader classLoader, @Nullable Supplier<String> toolTip) {
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)originalClassLoader, (String)"originalClassLoader");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            ImageDataByPathLoader originalLoader = new ImageDataByPathLoader(originalPath, originalClassLoader, null, null);
            ImageDataByPathLoader loader = patched == null ? originalLoader : new ImageDataByPathLoader(path, classLoader, originalLoader, null);
            ImageDataLoader imageDataLoader = loader;
            ImageDataByPathLoader imageDataByPathLoader = loader.original;
            if (imageDataByPathLoader == null) {
                imageDataByPathLoader = loader;
            }
            return new CachedImageIcon(imageDataLoader, toolTip, imageDataByPathLoader);
        }

        public static /* synthetic */ CachedImageIcon createIcon$intellij_platform_util_ui$default(Companion companion, String string, ClassLoader classLoader, Pair pair, String string2, ClassLoader classLoader2, Supplier supplier, int n, Object object) {
            if ((n & 0x20) != 0) {
                supplier = null;
            }
            return companion.createIcon$intellij_platform_util_ui(string, classLoader, (Pair<String, ? extends ClassLoader>)pair, string2, classLoader2, supplier);
        }

        private final ImageDataLoader doPatch(ImageDataByPathLoader originalLoader, IconTransform transform, boolean isOriginal) {
            ClassLoader classLoader;
            Pair<String, ClassLoader> pair = transform.patchPath(originalLoader.getPath(), originalLoader.classLoader);
            if (pair == null) {
                return isOriginal ? null : (ImageDataLoader)originalLoader;
            }
            Pair<String, ClassLoader> patched = pair;
            if (patched.getSecond() == null) {
                classLoader = originalLoader.classLoader;
            } else {
                Object object = patched.getSecond();
                Intrinsics.checkNotNull((Object)object);
                classLoader = (ClassLoader)object;
            }
            ClassLoader classLoader2 = classLoader;
            return StringsKt.startsWith$default((String)((String)patched.getFirst()), (String)"file:/", (boolean)false, (int)2, null) ? (ImageDataLoader)new ImageDataByFilePathLoader((String)patched.getFirst()) : (ImageDataLoader)new ImageDataByPathLoader(ImageDataByPathLoaderKt.normalizePath((String)patched.getFirst()), classLoader2, originalLoader, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

